<?php

/**
 * Class that operate on table 'expensestype'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ExpensestypeMySqlDAO implements ExpensestypeDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ExpensestypeMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM expensestype WHERE expensestypeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM expensestype';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM expensestype ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param expensestype primary key
     */
    public function delete($expensestypeid) {
        $sql = 'DELETE FROM expensestype WHERE expensestypeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($expensestypeid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ExpensestypeMySql expensestype
     */
    public function insert($expensestype) {
        $sql = 'INSERT INTO expensestype (expensestypename, expensestypedetails, expensestypedate, conditions, userid, parent,type,saveid,addOnlyGroupIds) VALUES (?, ?, ?, ?, ?, ? ,?,?,?)';
        $sqlQuery = new SqlQuery($sql);
        //print($sql);
        $sqlQuery->set($expensestype->expensestypename);
        $sqlQuery->setString2($expensestype->expensestypedetails);
        $sqlQuery->set($expensestype->expensestypedate);
        $sqlQuery->setNumber($expensestype->conditions);
        $sqlQuery->setNumber($expensestype->userid);
        $sqlQuery->setNumber($expensestype->parent);
        $sqlQuery->setNumber($expensestype->type);
        $sqlQuery->setNumber($expensestype->saveid);
        $sqlQuery->set($expensestype->addOnlyGroupIds);

        $id = $this->executeInsert($sqlQuery);

        $expensestype->expensestypeid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ExpensestypeMySql expensestype
     */
    public function update($expensestype) {
        $sql = 'UPDATE expensestype SET expensestypename = ?, expensestypedetails = ?, expensestypedate = ?, conditions = ?, userid = ?, parent = ?, type= ?, saveid=?, addOnlyGroupIds=? WHERE expensestypeid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($expensestype->expensestypename);
        $sqlQuery->setString2($expensestype->expensestypedetails);
        $sqlQuery->set($expensestype->expensestypedate);
        $sqlQuery->setNumber($expensestype->conditions);
        $sqlQuery->setNumber($expensestype->userid);
        $sqlQuery->setNumber($expensestype->parent);
        $sqlQuery->setNumber($expensestype->type);
        $sqlQuery->setNumber($expensestype->saveid);
        $sqlQuery->set($expensestype->addOnlyGroupIds);

        $sqlQuery->setNumber($expensestype->expensestypeid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM expensestype';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByExpensestypename($value) {
        $sql = 'SELECT * FROM expensestype WHERE expensestypename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExpensestypedetails($value) {
        $sql = 'SELECT * FROM expensestype WHERE expensestypedetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExpensestypedate($value) {
        $sql = 'SELECT * FROM expensestype WHERE expensestypedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM expensestype WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);

        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM expensestype WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParent($value) {
        $sql = 'SELECT * FROM expensestype WHERE parent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByExpensestypename($value) {
        $sql = 'DELETE FROM expensestype WHERE expensestypename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExpensestypedetails($value) {
        $sql = 'DELETE FROM expensestype WHERE expensestypedetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExpensestypedate($value) {
        $sql = 'DELETE FROM expensestype WHERE expensestypedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM expensestype WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM expensestype WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParent($value) {
        $sql = 'DELETE FROM expensestype WHERE parent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ExpensestypeMySql
     */
    protected function readRow($row) {
        $expensestype = new Expensestype();

        $expensestype->expensestypeid = isset($row['expensestypeid']) ? $row['expensestypeid'] : '';
        $expensestype->expensestypename = isset($row['expensestypename']) ? $row['expensestypename'] : '';
        $expensestype->expensestypedetails = isset($row['expensestypedetails']) ? $row['expensestypedetails'] : '';
        $expensestype->expensestypedate = isset($row['expensestypedate']) ? $row['expensestypedate'] : '';
        $expensestype->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $expensestype->userid = isset($row['userid']) ? $row['userid'] : '';
        $expensestype->parent = isset($row['parent']) ? $row['parent'] : '';
        $expensestype->type = isset($row['type']) ? $row['type'] : '';
        $expensestype->saveid = isset($row['saveid']) ? $row['saveid'] : '';
        $expensestype->addOnlyGroupIds = isset($row['addOnlyGroupIds']) ? $row['addOnlyGroupIds'] : '';
        $expensestype->sumExpensesValue = isset($row['sumExpensesValue']) ? $row['sumExpensesValue'] : '';



        return $expensestype;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ExpensestypeMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>