<?php
/**
 * Class that operate on table 'employeeclosedayhistory'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-11-20 02:16
 */
class EmployeeclosedayhistoryMySqlDAO implements EmployeeclosedayhistoryDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return EmployeeclosedayhistoryMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM employeeclosedayhistory WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM employeeclosedayhistory';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM employeeclosedayhistory ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param employeeclosedayhistory primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM employeeclosedayhistory WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param EmployeeclosedayhistoryMySql employeeclosedayhistory
 	 */
	public function insert($employeeclosedayhistory){
		$sql = 'INSERT INTO employeeclosedayhistory (employeeid, day, attendanceTime, departureTime, latePeriod, lateHasPermission, lateDiscount, isAbsent, absentHasPermission, absentDiscount, userid, sysdate, del, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($employeeclosedayhistory->employeeid);
		$sqlQuery->set($employeeclosedayhistory->day);
		$sqlQuery->set($employeeclosedayhistory->attendanceTime);
		$sqlQuery->set($employeeclosedayhistory->departureTime);
		$sqlQuery->set($employeeclosedayhistory->latePeriod);
		$sqlQuery->setNumber($employeeclosedayhistory->lateHasPermission);
		$sqlQuery->set($employeeclosedayhistory->lateDiscount);
		$sqlQuery->setNumber($employeeclosedayhistory->isAbsent);
		$sqlQuery->setNumber($employeeclosedayhistory->absentHasPermission);
		$sqlQuery->set($employeeclosedayhistory->absentDiscount);
		$sqlQuery->setNumber($employeeclosedayhistory->userid);
		$sqlQuery->set($employeeclosedayhistory->sysdate);
		$sqlQuery->setNumber($employeeclosedayhistory->del);
		$sqlQuery->setNumber($employeeclosedayhistory->status);

		$id = $this->executeInsert($sqlQuery);	
		$employeeclosedayhistory->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param EmployeeclosedayhistoryMySql employeeclosedayhistory
 	 */
	public function update($employeeclosedayhistory){
		$sql = 'UPDATE employeeclosedayhistory SET employeeid = ?, day = ?, attendanceTime = ?, departureTime = ?, latePeriod = ?, lateHasPermission = ?, lateDiscount = ?, isAbsent = ?, absentHasPermission = ?, absentDiscount = ?, userid = ?, sysdate = ?, del = ?, status = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($employeeclosedayhistory->employeeid);
		$sqlQuery->set($employeeclosedayhistory->day);
		$sqlQuery->set($employeeclosedayhistory->attendanceTime);
		$sqlQuery->set($employeeclosedayhistory->departureTime);
		$sqlQuery->set($employeeclosedayhistory->latePeriod);
		$sqlQuery->setNumber($employeeclosedayhistory->lateHasPermission);
		$sqlQuery->set($employeeclosedayhistory->lateDiscount);
		$sqlQuery->setNumber($employeeclosedayhistory->isAbsent);
		$sqlQuery->setNumber($employeeclosedayhistory->absentHasPermission);
		$sqlQuery->set($employeeclosedayhistory->absentDiscount);
		$sqlQuery->setNumber($employeeclosedayhistory->userid);
		$sqlQuery->set($employeeclosedayhistory->sysdate);
		$sqlQuery->setNumber($employeeclosedayhistory->del);
                $sqlQuery->setNumber($employeeclosedayhistory->status);

		$sqlQuery->setNumber($employeeclosedayhistory->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM employeeclosedayhistory';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByEmployeeid($value){
		$sql = 'SELECT * FROM employeeclosedayhistory WHERE employeeid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDay($value){
		$sql = 'SELECT * FROM employeeclosedayhistory WHERE day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAttendanceTime($value){
		$sql = 'SELECT * FROM employeeclosedayhistory WHERE attendanceTime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDepartureTime($value){
		$sql = 'SELECT * FROM employeeclosedayhistory WHERE departureTime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLatePeriod($value){
		$sql = 'SELECT * FROM employeeclosedayhistory WHERE latePeriod = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLateHasPermission($value){
		$sql = 'SELECT * FROM employeeclosedayhistory WHERE lateHasPermission = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLateDiscount($value){
		$sql = 'SELECT * FROM employeeclosedayhistory WHERE lateDiscount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByIsAbsent($value){
		$sql = 'SELECT * FROM employeeclosedayhistory WHERE isAbsent = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAbsentHasPermission($value){
		$sql = 'SELECT * FROM employeeclosedayhistory WHERE absentHasPermission = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAbsentDiscount($value){
		$sql = 'SELECT * FROM employeeclosedayhistory WHERE absentDiscount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM employeeclosedayhistory WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM employeeclosedayhistory WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDel($value){
		$sql = 'SELECT * FROM employeeclosedayhistory WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByEmployeeid($value){
		$sql = 'DELETE FROM employeeclosedayhistory WHERE employeeid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDay($value){
		$sql = 'DELETE FROM employeeclosedayhistory WHERE day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAttendanceTime($value){
		$sql = 'DELETE FROM employeeclosedayhistory WHERE attendanceTime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDepartureTime($value){
		$sql = 'DELETE FROM employeeclosedayhistory WHERE departureTime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLatePeriod($value){
		$sql = 'DELETE FROM employeeclosedayhistory WHERE latePeriod = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLateHasPermission($value){
		$sql = 'DELETE FROM employeeclosedayhistory WHERE lateHasPermission = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLateDiscount($value){
		$sql = 'DELETE FROM employeeclosedayhistory WHERE lateDiscount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByIsAbsent($value){
		$sql = 'DELETE FROM employeeclosedayhistory WHERE isAbsent = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAbsentHasPermission($value){
		$sql = 'DELETE FROM employeeclosedayhistory WHERE absentHasPermission = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAbsentDiscount($value){
		$sql = 'DELETE FROM employeeclosedayhistory WHERE absentDiscount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM employeeclosedayhistory WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM employeeclosedayhistory WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDel($value){
		$sql = 'DELETE FROM employeeclosedayhistory WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return EmployeeclosedayhistoryMySql 
	 */
	protected function readRow($row){
		$employeeclosedayhistory = new Employeeclosedayhistory();
		
		$employeeclosedayhistory->id = $row['id'];
		$employeeclosedayhistory->employeeid = $row['employeeid'];
		$employeeclosedayhistory->day = $row['day'];
		$employeeclosedayhistory->attendanceTime = $row['attendanceTime'];
		$employeeclosedayhistory->departureTime = $row['departureTime'];
		$employeeclosedayhistory->latePeriod = $row['latePeriod'];
		$employeeclosedayhistory->lateHasPermission = $row['lateHasPermission'];
		$employeeclosedayhistory->lateDiscount = $row['lateDiscount'];
		$employeeclosedayhistory->isAbsent = $row['isAbsent'];
		$employeeclosedayhistory->absentHasPermission = $row['absentHasPermission'];
		$employeeclosedayhistory->absentDiscount = $row['absentDiscount'];
		$employeeclosedayhistory->userid = $row['userid'];
		$employeeclosedayhistory->sysdate = $row['sysdate'];
		$employeeclosedayhistory->del = $row['del'];
		$employeeclosedayhistory->status = $row['status'];

		return $employeeclosedayhistory;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return EmployeeclosedayhistoryMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>