<?php
/**
 * Class that operate on table 'employeeattendancesystem'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-11-11 23:00
 */
class EmployeeattendancesystemMySqlDAO implements EmployeeattendancesystemDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return EmployeeattendancesystemMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM employeeattendancesystem';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM employeeattendancesystem ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param employeeattendancesystem primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM employeeattendancesystem WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param EmployeeattendancesystemMySql employeeattendancesystem
 	 */
	public function insert($employeeattendancesystem){
		$sql = 'INSERT INTO employeeattendancesystem (name, attendanceTime, departureTime, halfHourLateWithPermissionDisount, hourLateWithPermissionDisount, hourAndHalfLateWithPermissionDisount, twoHoursLateWithPermissionDisount, halfHourLateWithoutPermissionDisount, hourLateWithoutPermissionDisount, hourAndHalfLateWithoutPermissionDisount, twoHoursLateWithoutPermissionDisount, halfHourPermissionDisount, hourPermissionDisount, hourAndHalfPermissionDisount, twoHoursPermissionDisount, dayAbsenceWithPermissionDisount, dayAbsenceWithoutPermissionDisount, userid, del, sysdate,moreThanTwoHoursLateWithPermissionDisount,moreThanTwoHoursLateWithoutPermissionDisount) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($employeeattendancesystem->name);
		$sqlQuery->set($employeeattendancesystem->attendanceTime);
		$sqlQuery->set($employeeattendancesystem->departureTime);
		$sqlQuery->set($employeeattendancesystem->halfHourLateWithPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->hourLateWithPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->hourAndHalfLateWithPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->twoHoursLateWithPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->halfHourLateWithoutPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->hourLateWithoutPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->hourAndHalfLateWithoutPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->twoHoursLateWithoutPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->halfHourPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->hourPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->hourAndHalfPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->twoHoursPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->dayAbsenceWithPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->dayAbsenceWithoutPermissionDisount);
		$sqlQuery->setNumber($employeeattendancesystem->userid);
		$sqlQuery->setNumber($employeeattendancesystem->del);
		$sqlQuery->set($employeeattendancesystem->sysdate);
		$sqlQuery->set($employeeattendancesystem->moreThanTwoHoursLateWithPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->moreThanTwoHoursLateWithoutPermissionDisount);

		$id = $this->executeInsert($sqlQuery);	
		$employeeattendancesystem->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param EmployeeattendancesystemMySql employeeattendancesystem
 	 */
	public function update($employeeattendancesystem){
		$sql = 'UPDATE employeeattendancesystem SET name = ?, attendanceTime = ?, departureTime = ?, halfHourLateWithPermissionDisount = ?, hourLateWithPermissionDisount = ?, hourAndHalfLateWithPermissionDisount = ?, twoHoursLateWithPermissionDisount = ?, halfHourLateWithoutPermissionDisount = ?, hourLateWithoutPermissionDisount = ?, hourAndHalfLateWithoutPermissionDisount = ?, twoHoursLateWithoutPermissionDisount = ?, halfHourPermissionDisount = ?, hourPermissionDisount = ?, hourAndHalfPermissionDisount = ?, twoHoursPermissionDisount = ?, dayAbsenceWithPermissionDisount = ?, dayAbsenceWithoutPermissionDisount = ?, userid = ?, del = ?, sysdate = ?,moreThanTwoHoursLateWithPermissionDisount = ?,moreThanTwoHoursLateWithoutPermissionDisount = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($employeeattendancesystem->name);
		$sqlQuery->set($employeeattendancesystem->attendanceTime);
		$sqlQuery->set($employeeattendancesystem->departureTime);
		$sqlQuery->set($employeeattendancesystem->halfHourLateWithPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->hourLateWithPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->hourAndHalfLateWithPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->twoHoursLateWithPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->halfHourLateWithoutPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->hourLateWithoutPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->hourAndHalfLateWithoutPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->twoHoursLateWithoutPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->halfHourPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->hourPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->hourAndHalfPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->twoHoursPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->dayAbsenceWithPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->dayAbsenceWithoutPermissionDisount);
		$sqlQuery->setNumber($employeeattendancesystem->userid);
		$sqlQuery->setNumber($employeeattendancesystem->del);
		$sqlQuery->set($employeeattendancesystem->sysdate);
                $sqlQuery->set($employeeattendancesystem->moreThanTwoHoursLateWithPermissionDisount);
		$sqlQuery->set($employeeattendancesystem->moreThanTwoHoursLateWithoutPermissionDisount);

		$sqlQuery->setNumber($employeeattendancesystem->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM employeeattendancesystem';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByName($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAttendanceTime($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE attendanceTime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDepartureTime($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE departureTime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHalfHourLateWithPermissionDisount($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE halfHourLateWithPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHourLateWithPermissionDisount($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE hourLateWithPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHourAndHalfLateWithPermissionDisount($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE hourAndHalfLateWithPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTwoHoursLateWithPermissionDisount($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE twoHoursLateWithPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHalfHourLateWithoutPermissionDisount($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE halfHourLateWithoutPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHourLateWithoutPermissionDisount($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE hourLateWithoutPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHourAndHalfLateWithoutPermissionDisount($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE hourAndHalfLateWithoutPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTwoHoursLateWithoutPermissionDisount($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE twoHoursLateWithoutPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHalfHourPermissionDisount($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE halfHourPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHourPermissionDisount($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE hourPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHourAndHalfPermissionDisount($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE hourAndHalfPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTwoHoursPermissionDisount($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE twoHoursPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDayAbsenceWithPermissionDisount($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE dayAbsenceWithPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDayAbsenceWithoutPermissionDisount($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE dayAbsenceWithoutPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDel($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM employeeattendancesystem WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByName($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAttendanceTime($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE attendanceTime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDepartureTime($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE departureTime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHalfHourLateWithPermissionDisount($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE halfHourLateWithPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHourLateWithPermissionDisount($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE hourLateWithPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHourAndHalfLateWithPermissionDisount($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE hourAndHalfLateWithPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTwoHoursLateWithPermissionDisount($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE twoHoursLateWithPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHalfHourLateWithoutPermissionDisount($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE halfHourLateWithoutPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHourLateWithoutPermissionDisount($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE hourLateWithoutPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHourAndHalfLateWithoutPermissionDisount($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE hourAndHalfLateWithoutPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTwoHoursLateWithoutPermissionDisount($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE twoHoursLateWithoutPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHalfHourPermissionDisount($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE halfHourPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHourPermissionDisount($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE hourPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHourAndHalfPermissionDisount($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE hourAndHalfPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTwoHoursPermissionDisount($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE twoHoursPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDayAbsenceWithPermissionDisount($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE dayAbsenceWithPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDayAbsenceWithoutPermissionDisount($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE dayAbsenceWithoutPermissionDisount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDel($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM employeeattendancesystem WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return EmployeeattendancesystemMySql 
	 */
	protected function readRow($row){
		$employeeattendancesystem = new Employeeattendancesystem();
		
		$employeeattendancesystem->id = $row['id'];
		$employeeattendancesystem->name = $row['name'];
		$employeeattendancesystem->attendanceTime = $row['attendanceTime'];
		$employeeattendancesystem->departureTime = $row['departureTime'];
		$employeeattendancesystem->halfHourLateWithPermissionDisount = $row['halfHourLateWithPermissionDisount'];
		$employeeattendancesystem->hourLateWithPermissionDisount = $row['hourLateWithPermissionDisount'];
		$employeeattendancesystem->hourAndHalfLateWithPermissionDisount = $row['hourAndHalfLateWithPermissionDisount'];
		$employeeattendancesystem->twoHoursLateWithPermissionDisount = $row['twoHoursLateWithPermissionDisount'];
		$employeeattendancesystem->halfHourLateWithoutPermissionDisount = $row['halfHourLateWithoutPermissionDisount'];
		$employeeattendancesystem->hourLateWithoutPermissionDisount = $row['hourLateWithoutPermissionDisount'];
		$employeeattendancesystem->hourAndHalfLateWithoutPermissionDisount = $row['hourAndHalfLateWithoutPermissionDisount'];
		$employeeattendancesystem->twoHoursLateWithoutPermissionDisount = $row['twoHoursLateWithoutPermissionDisount'];
		$employeeattendancesystem->halfHourPermissionDisount = $row['halfHourPermissionDisount'];
		$employeeattendancesystem->hourPermissionDisount = $row['hourPermissionDisount'];
		$employeeattendancesystem->hourAndHalfPermissionDisount = $row['hourAndHalfPermissionDisount'];
		$employeeattendancesystem->twoHoursPermissionDisount = $row['twoHoursPermissionDisount'];
		$employeeattendancesystem->dayAbsenceWithPermissionDisount = $row['dayAbsenceWithPermissionDisount'];
		$employeeattendancesystem->dayAbsenceWithoutPermissionDisount = $row['dayAbsenceWithoutPermissionDisount'];
		$employeeattendancesystem->userid = $row['userid'];
		$employeeattendancesystem->del = $row['del'];
		$employeeattendancesystem->sysdate = $row['sysdate'];
		$employeeattendancesystem->moreThanTwoHoursLateWithPermissionDisount = $row['moreThanTwoHoursLateWithPermissionDisount'];
		$employeeattendancesystem->moreThanTwoHoursLateWithoutPermissionDisount = $row['moreThanTwoHoursLateWithoutPermissionDisount'];

		return $employeeattendancesystem;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return EmployeeattendancesystemMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>