<?php

/**
 * Class that operate on table 'datedchecked'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-04-19 11:00
 */
class DatedcheckedMySqlDAO implements DatedcheckedDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return DatedcheckedMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM datedchecked WHERE datedCheckedID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM datedchecked';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM datedchecked ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param datedchecked primary key
     */
    public function delete($datedCheckedID) {
        $sql = 'DELETE FROM datedchecked WHERE datedCheckedID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($datedCheckedID);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param DatedcheckedMySql datedchecked
     */
    public function insert($datedchecked) {

        $sql = 'INSERT INTO datedchecked (bankName, accountNo, checkValue, checkNo, dueDate, antherDetailes, done, operationDate, userID, clientNum , addType ,resonForRefused, dailyentryid , checkdate,endorsePersonId,endorseComment,endorseDate) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ? , ?, ?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($datedchecked->bankName);
        $sqlQuery->setNumber($datedchecked->accountNo);
        $sqlQuery->set($datedchecked->checkValue);
        //$sqlQuery->setNumber($datedchecked->checkValue);
        $sqlQuery->setNumber($datedchecked->checkNo);
        $sqlQuery->set($datedchecked->dueDate);
        $sqlQuery->set($datedchecked->antherDetailes);
        $sqlQuery->setNumber($datedchecked->done);
        $sqlQuery->set($datedchecked->operationDate);
        $sqlQuery->setNumber($datedchecked->userID);
        $sqlQuery->setNumber($datedchecked->clientNum);
        $sqlQuery->setNumber($datedchecked->addType);
        $sqlQuery->set($datedchecked->resonForRefused);
        $sqlQuery->setNumber($datedchecked->dailyentryid);
        $sqlQuery->set($datedchecked->checkdate);
        $sqlQuery->setNumber($datedchecked->endorsePersonId);
        $sqlQuery->set($datedchecked->endorseComment);
        $sqlQuery->set($datedchecked->endorseDate);

        $id = $this->executeInsert($sqlQuery);
        $datedchecked->datedCheckedID = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param DatedcheckedMySql datedchecked
     */
    public function update($datedchecked) {
        $sql = 'UPDATE datedchecked SET bankName = ?, accountNo = ?, checkValue = ?, checkNo = ?, dueDate = ?, antherDetailes = ?, done = ?, operationDate = ?, userID = ?, clientNum = ?, dailyentryid = ? , checkdate = ?,endorsePersonId = ?,endorseComment = ?,endorseDate = ? WHERE datedCheckedID = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($datedchecked->bankName);
        $sqlQuery->setNumber($datedchecked->accountNo);
        $sqlQuery->setNumber($datedchecked->checkValue);
        $sqlQuery->setNumber($datedchecked->checkNo);
        $sqlQuery->set($datedchecked->dueDate);
        $sqlQuery->set($datedchecked->antherDetailes);
        $sqlQuery->setNumber($datedchecked->done);
        $sqlQuery->set($datedchecked->operationDate);
        $sqlQuery->setNumber($datedchecked->userID);
        $sqlQuery->setNumber($datedchecked->clientNum);
        $sqlQuery->setNumber($datedchecked->dailyentryid);
        $sqlQuery->set($datedchecked->checkdate);
        $sqlQuery->setNumber($datedchecked->endorsePersonId);
        $sqlQuery->set($datedchecked->endorseComment);
        $sqlQuery->set($datedchecked->endorseDate);

        $sqlQuery->setNumber($datedchecked->datedCheckedID);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM datedchecked';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBankName($value) {
        $sql = 'SELECT * FROM datedchecked WHERE bankName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountNo($value) {
        $sql = 'SELECT * FROM datedchecked WHERE accountNo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCheckValue($value) {
        $sql = 'SELECT * FROM datedchecked WHERE checkValue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCheckNo($value) {
        $sql = 'SELECT * FROM datedchecked WHERE checkNo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDueDate($value) {
        $sql = 'SELECT * FROM datedchecked WHERE dueDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAntherDetailes($value) {
        $sql = 'SELECT * FROM datedchecked WHERE antherDetailes = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDone($value) {
        $sql = 'SELECT * FROM datedchecked WHERE done = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOperationDate($value) {
        $sql = 'SELECT * FROM datedchecked WHERE operationDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserID($value) {
        $sql = 'SELECT * FROM datedchecked WHERE userID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientNum($value) {
        $sql = 'SELECT * FROM datedchecked WHERE clientNum = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBankName($value) {
        $sql = 'DELETE FROM datedchecked WHERE bankName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountNo($value) {
        $sql = 'DELETE FROM datedchecked WHERE accountNo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCheckValue($value) {
        $sql = 'DELETE FROM datedchecked WHERE checkValue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCheckNo($value) {
        $sql = 'DELETE FROM datedchecked WHERE checkNo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDueDate($value) {
        $sql = 'DELETE FROM datedchecked WHERE dueDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAntherDetailes($value) {
        $sql = 'DELETE FROM datedchecked WHERE antherDetailes = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDone($value) {
        $sql = 'DELETE FROM datedchecked WHERE done = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOperationDate($value) {
        $sql = 'DELETE FROM datedchecked WHERE operationDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserID($value) {
        $sql = 'DELETE FROM datedchecked WHERE userID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientNum($value) {
        $sql = 'DELETE FROM datedchecked WHERE clientNum = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return DatedcheckedMySql
     */
    protected function readRow($row) {
        $datedchecked = new Datedchecked();

        $datedchecked->datedCheckedID = isset($row['datedCheckedID']) ? $row['datedCheckedID'] : '';
        $datedchecked->bankName = isset($row['bankName']) ? $row['bankName'] : '';
        $datedchecked->accountNo = isset($row['accountNo']) ? $row['accountNo'] : '';
        $datedchecked->checkValue = isset($row['checkValue']) ? $row['checkValue'] : '';
        $datedchecked->checkNo = isset($row['checkNo']) ? $row['checkNo'] : '';
        $datedchecked->dueDate = isset($row['dueDate']) ? $row['dueDate'] : '';
        $datedchecked->antherDetailes = isset($row['antherDetailes']) ? $row['antherDetailes'] : '';
        $datedchecked->done = isset($row['done']) ? $row['done'] : '';
        $datedchecked->operationDate = isset($row['operationDate']) ? $row['operationDate'] : '';
        $datedchecked->userID = isset($row['userID']) ? $row['userID'] : '';
        $datedchecked->clientNum = isset($row['clientNum']) ? $row['clientNum'] : '';
        $datedchecked->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $datedchecked->suppliername = isset($row['suppliername']) ? $row['suppliername'] : '';
        $datedchecked->addType = isset($row['addType']) ? $row['addType'] : '';
        $datedchecked->resonForRefused = isset($row['resonForRefused']) ? $row['resonForRefused'] : '';
        $datedchecked->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $datedchecked->checkdate = isset($row['checkdate']) ? $row['checkdate'] : '';
        $datedchecked->endorsePersonId = isset($row['endorsePersonId']) ? $row['endorsePersonId'] : '';
        $datedchecked->endorseComment = isset($row['endorseComment']) ? $row['endorseComment'] : '';
        $datedchecked->endorseDate = isset($row['endorseDate']) ? $row['endorseDate'] : '';


        return $datedchecked;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return DatedcheckedMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>