<?php

/**
 * Class that operate on table 'checkcontroller'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-07 12:05
 */
class CheckcontrollerMySqlDAO implements CheckcontrollerDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return CheckcontrollerMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM checkcontroller WHERE checkControllerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM checkcontroller';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM checkcontroller ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param checkcontroller primary key
     */
    public function delete($checkControllerid) {
        $sql = 'DELETE FROM checkcontroller WHERE checkControllerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($checkControllerid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param CheckcontrollerMySql checkcontroller
     */
    public function insert($checkcontroller) {
        $sql = 'INSERT INTO checkcontroller (checkid, controllerid, type) VALUES (?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($checkcontroller->checkid);
        $sqlQuery->setNumber($checkcontroller->controllerid);
        $sqlQuery->set($checkcontroller->type);

        $id = $this->executeInsert($sqlQuery);
        $checkcontroller->checkControllerid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param CheckcontrollerMySql checkcontroller
     */
    public function update($checkcontroller) {
        $sql = 'UPDATE checkcontroller SET checkid = ?, controllerid = ?, type = ? WHERE checkControllerid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($checkcontroller->checkid);
        $sqlQuery->setNumber($checkcontroller->controllerid);
        $sqlQuery->set($checkcontroller->type);

        $sqlQuery->setNumber($checkcontroller->checkControllerid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM checkcontroller';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByCheckid($value) {
        $sql = 'SELECT * FROM checkcontroller WHERE checkid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByControllerid($value) {
        $sql = 'SELECT * FROM checkcontroller WHERE controllerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getRow($sqlQuery);
    }

    public function queryByType($value) {
        $sql = 'SELECT * FROM checkcontroller WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByCheckid($value) {
        $sql = 'DELETE FROM checkcontroller WHERE checkid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByControllerid($value) {
        $sql = 'DELETE FROM checkcontroller WHERE controllerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByType($value) {
        $sql = 'DELETE FROM checkcontroller WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return CheckcontrollerMySql
     */
    protected function readRow($row) {
        $checkcontroller = new Checkcontroller();

        $checkcontroller->checkControllerid = isset($row['checkControllerid']) ? $row['checkControllerid'] : '';
        $checkcontroller->checkid = isset($row['checkid']) ? $row['checkid'] : '';
        $checkcontroller->controllerid = isset($row['controllerid']) ? $row['controllerid'] : '';
        $checkcontroller->type = isset($row['type']) ? $row['type'] : '';

        return $checkcontroller;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return CheckcontrollerMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>