<?php

/**
 * Class that operate on table 'cashtransfer'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-12-07 10:44
 */
class CashtransferMySqlDAO implements CashtransferDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return CashtransferMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM cashtransfer WHERE cashtransferid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM cashtransfer';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM cashtransfer ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param cashtransfer primary key
     */
    public function delete($cashtransferid) {
        $sql = 'DELETE FROM cashtransfer WHERE cashtransferid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($cashtransferid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param CashtransferMySql cashtransfer
     */
    public function insert($cashtransfer) {
        $sql = 'INSERT INTO cashtransfer (bankaccountid, saveid, accountbeforevalue, cashtransferuser, cashtransferamount, cashtransferdate, cashtransfernote, userid, conditions, cashtransfernumber, type,dailyentryid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($cashtransfer->bankaccountid);
        $sqlQuery->setNumber($cashtransfer->saveid);
        $sqlQuery->set($cashtransfer->accountbeforevalue);
        $sqlQuery->set($cashtransfer->cashtransferuser);
        $sqlQuery->set($cashtransfer->cashtransferamount);
        $sqlQuery->set($cashtransfer->cashtransferdate);
        $sqlQuery->set($cashtransfer->cashtransfernote);
        $sqlQuery->setNumber($cashtransfer->userid);
        $sqlQuery->setNumber($cashtransfer->conditions);
        $sqlQuery->set($cashtransfer->cashtransfernumber);
        $sqlQuery->setNumber($cashtransfer->type);
        $sqlQuery->setNumber($cashtransfer->dailyentryid);

        $id = $this->executeInsert($sqlQuery);
        $cashtransfer->cashtransferid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param CashtransferMySql cashtransfer
     */
    public function update($cashtransfer) {
        $sql = 'UPDATE cashtransfer SET bankaccountid = ?, saveid = ?, accountbeforevalue = ?, cashtransferuser = ?, cashtransferamount = ?, cashtransferdate = ?, cashtransfernote = ?, userid = ?, conditions = ?, cashtransfernumber = ?, type = ?, dailyentryid=? WHERE cashtransferid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($cashtransfer->bankaccountid);
        $sqlQuery->setNumber($cashtransfer->saveid);
        $sqlQuery->set($cashtransfer->accountbeforevalue);
        $sqlQuery->set($cashtransfer->cashtransferuser);
        $sqlQuery->set($cashtransfer->cashtransferamount);
        $sqlQuery->set($cashtransfer->cashtransferdate);
        $sqlQuery->set($cashtransfer->cashtransfernote);
        $sqlQuery->setNumber($cashtransfer->userid);
        $sqlQuery->setNumber($cashtransfer->conditions);
        $sqlQuery->set($cashtransfer->cashtransfernumber);
        $sqlQuery->setNumber($cashtransfer->type);
        $sqlQuery->setNumber($cashtransfer->dailyentryid);

        $sqlQuery->setNumber($cashtransfer->cashtransferid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM cashtransfer';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBankaccountid($value) {
        $sql = 'SELECT * FROM cashtransfer WHERE bankaccountid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveid($value) {
        $sql = 'SELECT * FROM cashtransfer WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountbeforevalue($value) {
        $sql = 'SELECT * FROM cashtransfer WHERE accountbeforevalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCashtransferuser($value) {
        $sql = 'SELECT * FROM cashtransfer WHERE cashtransferuser = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCashtransferamount($value) {
        $sql = 'SELECT * FROM cashtransfer WHERE cashtransferamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCashtransferdate($value) {
        $sql = 'SELECT * FROM cashtransfer WHERE cashtransferdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCashtransfernote($value) {
        $sql = 'SELECT * FROM cashtransfer WHERE cashtransfernote = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM cashtransfer WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM cashtransfer WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCashtransfernumber($value) {
        $sql = 'SELECT * FROM cashtransfer WHERE cashtransfernumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByType($value) {
        $sql = 'SELECT * FROM cashtransfer WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBankaccountid($value) {
        $sql = 'DELETE FROM cashtransfer WHERE bankaccountid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveid($value) {
        $sql = 'DELETE FROM cashtransfer WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountbeforevalue($value) {
        $sql = 'DELETE FROM cashtransfer WHERE accountbeforevalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCashtransferuser($value) {
        $sql = 'DELETE FROM cashtransfer WHERE cashtransferuser = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCashtransferamount($value) {
        $sql = 'DELETE FROM cashtransfer WHERE cashtransferamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCashtransferdate($value) {
        $sql = 'DELETE FROM cashtransfer WHERE cashtransferdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCashtransfernote($value) {
        $sql = 'DELETE FROM cashtransfer WHERE cashtransfernote = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM cashtransfer WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM cashtransfer WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCashtransfernumber($value) {
        $sql = 'DELETE FROM cashtransfer WHERE cashtransfernumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByType($value) {
        $sql = 'DELETE FROM cashtransfer WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return CashtransferMySql
     */
    protected function readRow($row) {
        $cashtransfer = new Cashtransfer();

        $cashtransfer->cashtransferid = isset($row['cashtransferid']) ? $row['cashtransferid'] : '';
        $cashtransfer->bankaccountid = isset($row['bankaccountid']) ? $row['bankaccountid'] : '';
        $cashtransfer->saveid = isset($row['saveid']) ? $row['saveid'] : '';
        $cashtransfer->accountbeforevalue = isset($row['accountbeforevalue']) ? $row['accountbeforevalue'] : '';
        $cashtransfer->cashtransferuser = isset($row['cashtransferuser']) ? $row['cashtransferuser'] : '';
        $cashtransfer->cashtransferamount = isset($row['cashtransferamount']) ? $row['cashtransferamount'] : '';
        $cashtransfer->cashtransferdate = isset($row['cashtransferdate']) ? $row['cashtransferdate'] : '';
        $cashtransfer->cashtransfernote = isset($row['cashtransfernote']) ? $row['cashtransfernote'] : '';
        $cashtransfer->userid = isset($row['userid']) ? $row['userid'] : '';
        $cashtransfer->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $cashtransfer->cashtransfernumber = isset($row['cashtransfernumber']) ? $row['cashtransfernumber'] : '';
        $cashtransfer->type = isset($row['type']) ? $row['type'] : '';
        $cashtransfer->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';

        //required
        $cashtransfer->bankname = isset($row['bankname']) ? $row['bankname'] : '';
        $cashtransfer->accountname = isset($row['accountname']) ? $row['accountname'] : '';
        $cashtransfer->accountnumber = isset($row['accountnumber']) ? $row['accountnumber'] : '';
        $cashtransfer->savename = isset($row['savename']) ? $row['savename'] : '';
        $cashtransfer->bankid = isset($row['bankid']) ? $row['bankid'] : '';


        return $cashtransfer;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return CashtransferMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>