<?php

/**
 * Class that operate on table 'buyandruternbill'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-29 13:54
 */
class BuyandruternbillMySqlDAO implements BuyandruternbillDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BuyandruternbillMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM buyandruternbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM buyandruternbill ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param buyandruternbill primary key
     */
    public function delete($buybillid) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($buybillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BuyandruternbillMySql buyandruternbill
     */
    public function insert($buyandruternbill) {
        $sql = 'INSERT INTO buyandruternbill (buybillSerial, buybilldate, buybillsupplierid, buybilltotaldeptbefor, buybilltotaldeptafter, buybilldiscount, buybilldiscountrype, buybilltotalbill, buybillaftertotalbill, buybilltotalpayed, buybillfinalbill, buybillstoreid, buybillsysdate,comment, userid, conditions, buybillclientname, buybillsaveid, buybilldirectpayment, billnameid,payedtax,costcenterid,dailyentryid,delbyuserid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($buyandruternbill->buybillSerial);
        $sqlQuery->set($buyandruternbill->buybilldate);
        $sqlQuery->setNumber($buyandruternbill->buybillsupplierid);
        $sqlQuery->set($buyandruternbill->buybilltotaldeptbefor);
        $sqlQuery->set($buyandruternbill->buybilltotaldeptafter);
        $sqlQuery->set($buyandruternbill->buybilldiscount);
        $sqlQuery->setNumber($buyandruternbill->buybilldiscountrype);
        $sqlQuery->set($buyandruternbill->buybilltotalbill);
        $sqlQuery->set($buyandruternbill->buybillaftertotalbill);
        $sqlQuery->set($buyandruternbill->buybilltotalpayed);
        $sqlQuery->set($buyandruternbill->buybillfinalbill);
        $sqlQuery->setNumber($buyandruternbill->buybillstoreid);
        $sqlQuery->set($buyandruternbill->buybillsysdate);
        $sqlQuery->set($buyandruternbill->comment);
        $sqlQuery->setNumber($buyandruternbill->userid);
        $sqlQuery->setNumber($buyandruternbill->conditions);
        $sqlQuery->set($buyandruternbill->buybillclientname);
        $sqlQuery->setNumber($buyandruternbill->buybillsaveid);
        $sqlQuery->setNumber($buyandruternbill->buybilldirectpayment);
        $sqlQuery->setNumber($buyandruternbill->billnameid);
        $sqlQuery->set($buyandruternbill->payedtax);
        $sqlQuery->set($buyandruternbill->costcenterid);

        $sqlQuery->setNumber($buyandruternbill->dailyentryid);
        $sqlQuery->setNumber((int) $buyandruternbill->delbyuserid);


        $id = $this->executeInsert($sqlQuery);
        $buyandruternbill->buybillid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BuyandruternbillMySql buyandruternbill
     */
    public function update($buyandruternbill) {
        $sql = 'UPDATE buyandruternbill SET buybillSerial = ?, buybilldate = ?, buybillsupplierid = ?, buybilltotaldeptbefor = ?, buybilltotaldeptafter = ?, buybilldiscount = ?, buybilldiscountrype = ?, buybilltotalbill = ?, buybillaftertotalbill = ?, buybilltotalpayed = ?, buybillfinalbill = ?, buybillstoreid = ?, buybillsysdate = ?,comment = ?, userid = ?, conditions = ?, buybillclientname = ?, buybillsaveid = ?, buybilldirectpayment = ?, billnameid = ?,dailyentryid = ?,delbyuserid = ? WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($buyandruternbill->buybillSerial);
        $sqlQuery->set($buyandruternbill->buybilldate);
        $sqlQuery->setNumber($buyandruternbill->buybillsupplierid);
        $sqlQuery->set($buyandruternbill->buybilltotaldeptbefor);
        $sqlQuery->set($buyandruternbill->buybilltotaldeptafter);
        $sqlQuery->set($buyandruternbill->buybilldiscount);
        $sqlQuery->setNumber($buyandruternbill->buybilldiscountrype);
        $sqlQuery->set($buyandruternbill->buybilltotalbill);
        $sqlQuery->set($buyandruternbill->buybillaftertotalbill);
        $sqlQuery->set($buyandruternbill->buybilltotalpayed);
        $sqlQuery->set($buyandruternbill->buybillfinalbill);
        $sqlQuery->setNumber($buyandruternbill->buybillstoreid);
        $sqlQuery->set($buyandruternbill->buybillsysdate);
        $sqlQuery->set($buyandruternbill->comment);
        $sqlQuery->setNumber($buyandruternbill->userid);
        $sqlQuery->setNumber($buyandruternbill->conditions);
        $sqlQuery->set($buyandruternbill->buybillclientname);
        $sqlQuery->setNumber($buyandruternbill->buybillsaveid);
        $sqlQuery->setNumber($buyandruternbill->buybilldirectpayment);
        $sqlQuery->setNumber($buyandruternbill->billnameid);

        $sqlQuery->setNumber($buyandruternbill->dailyentryid);
        $sqlQuery->setNumber((int) $buyandruternbill->delbyuserid);

        $sqlQuery->setNumber($buyandruternbill->buybillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM buyandruternbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBuybillSerial($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybillSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldate($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillsupplierid($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybillsupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilltotaldeptbefor($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilltotaldeptafter($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldiscount($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldiscountrype($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybilldiscountrype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilltotalbill($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillaftertotalbill($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilltotalpayed($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillfinalbill($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillstoreid($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillsysdate($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillclientname($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillsaveid($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldirectpayment($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE buybilldirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillnameid($value) {
        $sql = 'SELECT * FROM buyandruternbill WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBuybillSerial($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybillSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldate($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillsupplierid($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybillsupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilltotaldeptbefor($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilltotaldeptafter($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldiscount($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldiscountrype($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybilldiscountrype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilltotalbill($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillaftertotalbill($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilltotalpayed($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillfinalbill($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillstoreid($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillsysdate($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillclientname($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillsaveid($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldirectpayment($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE buybilldirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillnameid($value) {
        $sql = 'DELETE FROM buyandruternbill WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BuyandruternbillMySql
     */
    protected function readRow($row) {
        $buyandruternbill = new Buyandruternbill();

        $buyandruternbill->buybillid = isset($row['buybillid']) ? $row['buybillid'] : '';
        $buyandruternbill->buybillSerial = isset($row['buybillSerial']) ? $row['buybillSerial'] : '';
        $buyandruternbill->buybilldate = isset($row['buybilldate']) ? $row['buybilldate'] : '';
        $buyandruternbill->buybillsupplierid = isset($row['buybillsupplierid']) ? $row['buybillsupplierid'] : '';
        $buyandruternbill->buybilltotaldeptbefor = isset($row['buybilltotaldeptbefor']) ? $row['buybilltotaldeptbefor'] : '';
        $buyandruternbill->buybilltotaldeptafter = isset($row['buybilltotaldeptafter']) ? $row['buybilltotaldeptafter'] : '';
        $buyandruternbill->buybilldiscount = isset($row['buybilldiscount']) ? $row['buybilldiscount'] : '';
        $buyandruternbill->buybilldiscountrype = isset($row['buybilldiscountrype']) ? $row['buybilldiscountrype'] : '';
        $buyandruternbill->buybilltotalbill = isset($row['buybilltotalbill']) ? $row['buybilltotalbill'] : '';
        $buyandruternbill->buybillaftertotalbill = isset($row['buybillaftertotalbill']) ? $row['buybillaftertotalbill'] : '';
        $buyandruternbill->buybilltotalpayed = isset($row['buybilltotalpayed']) ? $row['buybilltotalpayed'] : '';
        $buyandruternbill->buybillfinalbill = isset($row['buybillfinalbill']) ? $row['buybillfinalbill'] : '';
        $buyandruternbill->buybillstoreid = isset($row['buybillstoreid']) ? $row['buybillstoreid'] : '';
        $buyandruternbill->buybillsysdate = isset($row['buybillsysdate']) ? $row['buybillsysdate'] : '';
        $buyandruternbill->comment = isset($row['comment']) ? $row['comment'] : '';
        $buyandruternbill->userid = isset($row['userid']) ? $row['userid'] : '';
        $buyandruternbill->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $buyandruternbill->buybillclientname = isset($row['buybillclientname']) ? $row['buybillclientname'] : '';
        $buyandruternbill->buybillsaveid = isset($row['buybillsaveid']) ? $row['buybillsaveid'] : '';
        $buyandruternbill->buybilldirectpayment = isset($row['buybilldirectpayment']) ? $row['buybilldirectpayment'] : '';
        $buyandruternbill->billnameid = isset($row['billnameid']) ? $row['billnameid'] : '';

        $buyandruternbill->deletedbuyid = isset($row['deletedbuyid']) ? $row['deletedbuyid'] : '';
        $buyandruternbill->controlname = isset($row['controlname']) ? $row['controlname'] : '';
        $buyandruternbill->payedtax = isset($row['payedtax']) ? $row['payedtax'] : '';
        $buyandruternbill->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';


        $buyandruternbill->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';



        //required
        $buyandruternbill->suppliername = isset($row['suppliername']) ? $row['suppliername'] : '';
        $buyandruternbill->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $buyandruternbill->username = isset($row['username']) ? $row['username'] : '';
        $buyandruternbill->totalQty = isset($row['totalQty']) ? $row['totalQty'] : '';
        $buyandruternbill->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $buyandruternbill->delbyuserid = isset($row['delbyuserid']) ? $row['delbyuserid'] : '';
        $buyandruternbill->delbyusername = isset($row['delbyusername']) ? $row['delbyusername'] : '';

        return $buyandruternbill;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BuyandruternbillMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>