<?php

/**
 * Class that operate on table 'bindsettlement'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-07-04 13:41
 */
class BindsettlementMySqlDAO implements BindsettlementDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BindsettlementMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM bindsettlement WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM bindsettlement';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM bindsettlement ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param bindsettlement primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM bindsettlement WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BindsettlementMySql bindsettlement
     */
    public function insert($bindsettlement) {
        $sql = 'INSERT INTO bindsettlement (userid, employeeid, settlementway, settlementwayid, projectid, value, comment, deleted , dailyentryid , groupno) VALUES (? , ? , ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($bindsettlement->userid);
        $sqlQuery->setNumber($bindsettlement->employeeid);
        $sqlQuery->setNumber($bindsettlement->settlementway);
        $sqlQuery->setNumber($bindsettlement->settlementwayid);
        $sqlQuery->setNumber($bindsettlement->projectid);
        $sqlQuery->set($bindsettlement->value);
        $sqlQuery->setString2($bindsettlement->comment);
        $sqlQuery->setNumber($bindsettlement->deleted);
        $sqlQuery->setNumber($bindsettlement->dailyentryid);
        $sqlQuery->setNumber($bindsettlement->groupno);

        $id = $this->executeInsert($sqlQuery);
        $bindsettlement->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BindsettlementMySql bindsettlement
     */
    public function update($bindsettlement) {
        $sql = 'UPDATE bindsettlement SET userid = ?, employeeid = ?, settlementway = ?, settlementwayid = ?, projectid = ?, value = ?, comment = ?, deleted = ? , dailyentryid = ? , groupno = ?  WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($bindsettlement->userid);
        $sqlQuery->setNumber($bindsettlement->employeeid);
        $sqlQuery->setNumber($bindsettlement->settlementway);
        $sqlQuery->setNumber($bindsettlement->settlementwayid);
        $sqlQuery->setNumber($bindsettlement->projectid);
        $sqlQuery->set($bindsettlement->value);
        $sqlQuery->setString2($bindsettlement->comment);
        $sqlQuery->setNumber($bindsettlement->deleted);
        $sqlQuery->setNumber($bindsettlement->dailyentryid);
        $sqlQuery->setNumber($bindsettlement->groupno);


        $sqlQuery->setNumber($bindsettlement->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM bindsettlement';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM bindsettlement WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeeid($value) {
        $sql = 'SELECT * FROM bindsettlement WHERE employeeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySettlementway($value) {
        $sql = 'SELECT * FROM bindsettlement WHERE settlementway = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySettlementwayid($value) {
        $sql = 'SELECT * FROM bindsettlement WHERE settlementwayid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProjectid($value) {
        $sql = 'SELECT * FROM bindsettlement WHERE projectid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByValue($value) {
        $sql = 'SELECT * FROM bindsettlement WHERE value = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM bindsettlement WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeleted($value) {
        $sql = 'SELECT * FROM bindsettlement WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM bindsettlement WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeeid($value) {
        $sql = 'DELETE FROM bindsettlement WHERE employeeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySettlementway($value) {
        $sql = 'DELETE FROM bindsettlement WHERE settlementway = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySettlementwayid($value) {
        $sql = 'DELETE FROM bindsettlement WHERE settlementwayid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProjectid($value) {
        $sql = 'DELETE FROM bindsettlement WHERE projectid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByValue($value) {
        $sql = 'DELETE FROM bindsettlement WHERE value = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM bindsettlement WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeleted($value) {
        $sql = 'DELETE FROM bindsettlement WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BindsettlementMySql
     */
    protected function readRow($row) {
        $bindsettlement = new Bindsettlement();

        $bindsettlement->id = isset($row['id']) ? $row['id'] : '';
        $bindsettlement->userid = isset($row['userid']) ? $row['userid'] : '';
        $bindsettlement->employeeid = isset($row['employeeid']) ? $row['employeeid'] : '';
        $bindsettlement->settlementway = isset($row['settlementway']) ? $row['settlementway'] : '';
        $bindsettlement->settlementwayid = isset($row['settlementwayid']) ? $row['settlementwayid'] : '';
        $bindsettlement->projectid = isset($row['projectid']) ? $row['projectid'] : '';
        $bindsettlement->value = isset($row['value']) ? $row['value'] : '';
        $bindsettlement->comment = isset($row['comment']) ? $row['comment'] : '';
        $bindsettlement->deleted = isset($row['deleted']) ? $row['deleted'] : '';
        $bindsettlement->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $bindsettlement->groupno = isset($row['groupno']) ? $row['groupno'] : '';

        return $bindsettlement;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BindsettlementMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>