<?php

/**
 * Class that operate on table 'bind'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-07-04 13:41
 */
class BindMySqlDAO implements BindDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BindMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM bind WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM bind';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM bind ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param bind primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM bind WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BindMySql bind
     */
    public function insert($bind) {
        $sql = 'INSERT INTO bind (employeeid, bindtype, saveid, savevalue, bankid, bankaccount, ckekno, benefitname, ckekvalue, dailyentryid, userid, binddate, deleted) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($bind->employeeid);
        $sqlQuery->setNumber($bind->bindtype);
        $sqlQuery->setNumber($bind->saveid);
        $sqlQuery->set($bind->savevalue);
        $sqlQuery->setNumber($bind->bankid);
        $sqlQuery->setNumber($bind->bankaccount);
        $sqlQuery->set($bind->ckekno);
        $sqlQuery->set($bind->benefitname);
        $sqlQuery->set($bind->ckekvalue);
        $sqlQuery->setNumber($bind->dailyentryid);
        $sqlQuery->setNumber($bind->userid);
        $sqlQuery->set($bind->binddate);
        $sqlQuery->setNumber($bind->deleted);

        $id = $this->executeInsert($sqlQuery);
        $bind->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BindMySql bind
     */
    public function update($bind) {
        $sql = 'UPDATE bind SET employeeid = ?, bindtype = ?, saveid = ?, savevalue = ?, bankid = ?, bankaccount = ?, ckekno = ?, benefitname = ?, ckekvalue = ?, dailyentryid = ?, userid = ?, binddate = ?, deleted = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($bind->employeeid);
        $sqlQuery->setNumber($bind->bindtype);
        $sqlQuery->setNumber($bind->saveid);
        $sqlQuery->set($bind->savevalue);
        $sqlQuery->setNumber($bind->bankid);
        $sqlQuery->setNumber($bind->bankaccount);
        $sqlQuery->set($bind->ckekno);
        $sqlQuery->set($bind->benefitname);
        $sqlQuery->set($bind->ckekvalue);
        $sqlQuery->setNumber($bind->dailyentryid);
        $sqlQuery->setNumber($bind->userid);
        $sqlQuery->set($bind->binddate);
        $sqlQuery->setNumber($bind->deleted);

        $sqlQuery->setNumber($bind->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM bind';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByEmployeeid($value) {
        $sql = 'SELECT * FROM bind WHERE employeeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBindtype($value) {
        $sql = 'SELECT * FROM bind WHERE bindtype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveid($value) {
        $sql = 'SELECT * FROM bind WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySavevalue($value) {
        $sql = 'SELECT * FROM bind WHERE savevalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBankid($value) {
        $sql = 'SELECT * FROM bind WHERE bankid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBankaccount($value) {
        $sql = 'SELECT * FROM bind WHERE bankaccount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCkekno($value) {
        $sql = 'SELECT * FROM bind WHERE ckekno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBenefitname($value) {
        $sql = 'SELECT * FROM bind WHERE benefitname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCkekvalue($value) {
        $sql = 'SELECT * FROM bind WHERE ckekvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDailyentryid($value) {
        $sql = 'SELECT * FROM bind WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM bind WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBinddate($value) {
        $sql = 'SELECT * FROM bind WHERE binddate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeleted($value) {
        $sql = 'SELECT * FROM bind WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByEmployeeid($value) {
        $sql = 'DELETE FROM bind WHERE employeeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBindtype($value) {
        $sql = 'DELETE FROM bind WHERE bindtype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveid($value) {
        $sql = 'DELETE FROM bind WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySavevalue($value) {
        $sql = 'DELETE FROM bind WHERE savevalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBankid($value) {
        $sql = 'DELETE FROM bind WHERE bankid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBankaccount($value) {
        $sql = 'DELETE FROM bind WHERE bankaccount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCkekno($value) {
        $sql = 'DELETE FROM bind WHERE ckekno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBenefitname($value) {
        $sql = 'DELETE FROM bind WHERE benefitname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCkekvalue($value) {
        $sql = 'DELETE FROM bind WHERE ckekvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDailyentryid($value) {
        $sql = 'DELETE FROM bind WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM bind WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBinddate($value) {
        $sql = 'DELETE FROM bind WHERE binddate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeleted($value) {
        $sql = 'DELETE FROM bind WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BindMySql
     */
    protected function readRow($row) {
        $bind = new Bind();

        $bind->id = isset($row['id']) ? $row['id'] : '';
        $bind->employeeid = isset($row['employeeid']) ? $row['employeeid'] : '';
        $bind->bindtype = isset($row['bindtype']) ? $row['bindtype'] : '';
        $bind->saveid = isset($row['saveid']) ? $row['saveid'] : '';
        $bind->savevalue = isset($row['savevalue']) ? $row['savevalue'] : '';
        $bind->bankid = isset($row['bankid']) ? $row['bankid'] : '';
        $bind->bankaccount = isset($row['bankaccount']) ? $row['bankaccount'] : '';
        $bind->ckekno = isset($row['ckekno']) ? $row['ckekno'] : '';
        $bind->benefitname = isset($row['benefitname']) ? $row['benefitname'] : '';
        $bind->ckekvalue = isset($row['ckekvalue']) ? $row['ckekvalue'] : '';
        $bind->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $bind->userid = isset($row['userid']) ? $row['userid'] : '';
        $bind->binddate = isset($row['binddate']) ? $row['binddate'] : '';
        $bind->deleted = isset($row['deleted']) ? $row['deleted'] : '';
        $bind->employeeName = isset($row['employeeName']) ? $row['employeeName'] : '';

        return $bind;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BindMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>