<?php

/**
 * Class that operate on table 'billproperty'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class BillpropertyMySqlDAO implements BillpropertyDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BillpropertyMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM billproperty WHERE billpropertyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM billproperty';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM billproperty ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param billproperty primary key
     */
    public function delete($billpropertyid) {
        $sql = 'DELETE FROM billproperty WHERE billpropertyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($billpropertyid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BillpropertyMySql billproperty
     */
    public function insert($billproperty, $description) {
        $sql = 'INSERT INTO billproperty (billpropertyname, description, conditions) VALUES (?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($billproperty->billpropertyname);
        $sqlQuery->setString2($description);
        $sqlQuery->setNumber($billproperty->conditions);

        $id = $this->executeInsert($sqlQuery);
        $billproperty->billpropertyid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BillpropertyMySql billproperty
     */
    public function update($billproperty, $description) {
        $sql = 'UPDATE billproperty SET billpropertyname = ?, description = ?, conditions = ? WHERE billpropertyid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($billproperty->billpropertyname);
        $sqlQuery->setString2($description);
        $sqlQuery->setNumber($billproperty->conditions);

        $sqlQuery->setNumber($billproperty->billpropertyid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM billproperty';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBillpropertyname($value) {
        $sql = 'SELECT * FROM billproperty WHERE billpropertyname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDescription($value) {
        $sql = 'SELECT * FROM billproperty WHERE description = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM billproperty WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBillpropertyname($value) {
        $sql = 'DELETE FROM billproperty WHERE billpropertyname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDescription($value) {
        $sql = 'DELETE FROM billproperty WHERE description = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM billproperty WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BillpropertyMySql
     */
    protected function readRow($row) {
        $billproperty = new Billproperty();

        $billproperty->billpropertyid = isset($row['billpropertyid']) ? $row['billpropertyid'] : '';
        $billproperty->billpropertyname = isset($row['billpropertyname']) ? $row['billpropertyname'] : '';
        $billproperty->description = isset($row['description']) ? $row['description'] : '';
        $billproperty->conditions = isset($row['conditions']) ? $row['conditions'] : '';

        return $billproperty;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BillpropertyMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>