<?php

/**
 * Class that operate on table 'bank'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class BankMySqlDAO implements BankDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BankMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM bank WHERE bankid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM bank';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM bank ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param bank primary key
     */
    public function delete($bankid) {
        $sql = 'DELETE FROM bank WHERE bankid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($bankid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BankMySql bank
     */
    public function insert($bank, $bankdetails) {
        $sql = 'INSERT INTO bank (bankname, bankdetails, userid, conditions, bankdate) VALUES (?, "' . $bankdetails . '", ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($bank->bankname);
        //$sqlQuery->set($bank->bankdetails);
        $sqlQuery->setNumber($bank->userid);
        $sqlQuery->setNumber($bank->conditions);
        $sqlQuery->set($bank->bankdate);

        $id = $this->executeInsert($sqlQuery);
        $bank->bankid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BankMySql bank
     */
    public function update($bank, $bankdetails) {
        $sql = 'UPDATE bank SET bankname = ?, bankdetails = "' . $bankdetails . '", userid = ?, conditions = ?, bankdate = ? WHERE bankid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($bank->bankname);
        //$sqlQuery->set($bank->bankdetails);
        $sqlQuery->setNumber($bank->userid);
        $sqlQuery->setNumber($bank->conditions);
        $sqlQuery->set($bank->bankdate);

        $sqlQuery->setNumber($bank->bankid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM bank';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBankname($value) {
        $sql = 'SELECT * FROM bank WHERE bankname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBankdetails($value) {
        $sql = 'SELECT * FROM bank WHERE bankdetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM bank WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM bank WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBankdate($value) {
        $sql = 'SELECT * FROM bank WHERE bankdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBankname($value) {
        $sql = 'DELETE FROM bank WHERE bankname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBankdetails($value) {
        $sql = 'DELETE FROM bank WHERE bankdetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM bank WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM bank WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBankdate($value) {
        $sql = 'DELETE FROM bank WHERE bankdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BankMySql
     */
    protected function readRow($row) {
        $bank = new Bank();

        $bank->bankid = isset($row['bankid']) ? $row['bankid'] : '';
        $bank->bankname = isset($row['bankname']) ? $row['bankname'] : '';
        $bank->bankdetails = isset($row['bankdetails']) ? $row['bankdetails'] : '';
        $bank->userid = isset($row['userid']) ? $row['userid'] : '';
        $bank->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $bank->bankdate = isset($row['bankdate']) ? $row['bankdate'] : '';

        return $bank;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BankMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>