<?php

/**
 * Class that operate on table 'accountstreesetting'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-04-24 12:54
 */
class AccountstreesettingMySqlDAO implements AccountstreesettingDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return AccountstreesettingMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM accountstreesetting WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM accountstreesetting';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM accountstreesetting ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param accountstreesetting primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM accountstreesetting WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param AccountstreesettingMySql accountstreesetting
     */
    public function insert($accountstreesetting) {
        $sql = 'INSERT INTO accountstreesetting (levelno, nooffields) VALUES (?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($accountstreesetting->levelno);
        $sqlQuery->setNumber($accountstreesetting->nooffields);

        $id = $this->executeInsert($sqlQuery);
        $accountstreesetting->id = $id;

        return $id;
    }

    /**
     * Update record in table
     *
     * @param AccountstreesettingMySql accountstreesetting
     */
    public function update($accountstreesetting) {
        $sql = 'UPDATE accountstreesetting SET levelno = ?, nooffields = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($accountstreesetting->levelno);
        $sqlQuery->setNumber($accountstreesetting->nooffields);

        $sqlQuery->setNumber($accountstreesetting->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM accountstreesetting';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByLevelno($value) {
        $sql = 'SELECT * FROM accountstreesetting WHERE levelno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNooffields($value) {
        $sql = 'SELECT * FROM accountstreesetting WHERE nooffields = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByLevelno($value) {
        $sql = 'DELETE FROM accountstreesetting WHERE levelno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNooffields($value) {
        $sql = 'DELETE FROM accountstreesetting WHERE nooffields = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return AccountstreesettingMySql
     */
    protected function readRow($row) {
        $accountstreesetting = new Accountstreesetting();

        $accountstreesetting->id = isset($row['id']) ? $row['id'] : '';
        $accountstreesetting->levelno = isset($row['levelno']) ? $row['levelno'] : ''; 
        $accountstreesetting->nooffields = isset($row['nooffields']) ? $row['nooffields'] : ''; 

        return $accountstreesetting;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return AccountstreesettingMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>