<?php

/**
 * Class that operate on table 'accountstree'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-04-23 09:50
 */
class AccountstreeMySqlDAO implements AccountstreeDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return AccountstreeMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM accountstree WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM accountstree';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM accountstree ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param accountstree primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM accountstree WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param AccountstreeMySql accountstree
     */
    public function insert($accountstree) {
        $sql = 'INSERT INTO accountstree (name, customName, parent, itemtype, itemfrom, notes, del, userid, mydate, itemtype2, theValue, theOrder, layingOrder,reportid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($accountstree->name);
        $sqlQuery->set($accountstree->customName);
        $sqlQuery->setNumber($accountstree->parent);
        $sqlQuery->setNumber($accountstree->itemtype);
        $sqlQuery->setNumber($accountstree->itemfrom);
        $sqlQuery->setString2($accountstree->notes);
        $sqlQuery->setNumber($accountstree->del);
        $sqlQuery->setNumber($accountstree->userid);
        $sqlQuery->set($accountstree->mydate);
        $sqlQuery->setNumber($accountstree->itemtype2);
        $sqlQuery->set($accountstree->theValue);
        $sqlQuery->setNumber($accountstree->theOrder);
        $sqlQuery->set($accountstree->layingOrder);
        $sqlQuery->setNumber($accountstree->reportid);

        $id = $this->executeInsert($sqlQuery);
        $accountstree->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param AccountstreeMySql accountstree
     */
    public function update($accountstree) {
        $sql = 'UPDATE accountstree SET name = ?, customName = ?, parent = ?, itemtype = ?, itemfrom = ?, notes = ?, del = ?, userid = ?, mydate = ?, itemtype2 = ?, theValue = ?, theOrder = ?, layingOrder = ?,reportid = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($accountstree->name);
        $sqlQuery->set($accountstree->customName);
        $sqlQuery->setNumber($accountstree->parent);
        $sqlQuery->setNumber($accountstree->itemtype);
        $sqlQuery->setNumber($accountstree->itemfrom);
        $sqlQuery->setString2($accountstree->notes);
        $sqlQuery->setNumber($accountstree->del);
        $sqlQuery->setNumber($accountstree->userid);
        $sqlQuery->set($accountstree->mydate);
        $sqlQuery->setNumber($accountstree->itemtype2);
        $sqlQuery->set($accountstree->theValue);
        $sqlQuery->setNumber($accountstree->theOrder);
        $sqlQuery->set($accountstree->layingOrder);
        $sqlQuery->setNumber($accountstree->reportid);

        $sqlQuery->setNumber($accountstree->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM accountstree';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM accountstree WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCustomName($value) {
        $sql = 'SELECT * FROM accountstree WHERE customName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParent($value) {
        $sql = 'SELECT * FROM accountstree WHERE parent = ? AND del=0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByItemtype($value) {
        $sql = 'SELECT * FROM accountstree WHERE itemtype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByItemfrom($value) {
        $sql = 'SELECT * FROM accountstree WHERE itemfrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNotes($value) {
        $sql = 'SELECT * FROM accountstree WHERE notes = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM accountstree WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM accountstree WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMydate($value) {
        $sql = 'SELECT * FROM accountstree WHERE mydate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByItemtype2($value) {
        $sql = 'SELECT * FROM accountstree WHERE itemtype2 = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTheValue($value) {
        $sql = 'SELECT * FROM accountstree WHERE theValue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTheOrder($value) {
        $sql = 'SELECT * FROM accountstree WHERE theOrder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLayingOrder($value) {
        $sql = 'SELECT * FROM accountstree WHERE layingOrder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM accountstree WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParent($value) {
        $sql = 'DELETE FROM accountstree WHERE parent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByItemtype($value) {
        $sql = 'DELETE FROM accountstree WHERE itemtype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByItemfrom($value) {
        $sql = 'DELETE FROM accountstree WHERE itemfrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNotes($value) {
        $sql = 'DELETE FROM accountstree WHERE notes = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM accountstree WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM accountstree WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMydate($value) {
        $sql = 'DELETE FROM accountstree WHERE mydate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByItemtype2($value) {
        $sql = 'DELETE FROM accountstree WHERE itemtype2 = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTheValue($value) {
        $sql = 'DELETE FROM accountstree WHERE theValue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTheOrder($value) {
        $sql = 'DELETE FROM accountstree WHERE theOrder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLayingOrder($value) {
        $sql = 'DELETE FROM accountstree WHERE layingOrder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return AccountstreeMySql
     */
    protected function readRow($row) {
        $accountstree = new Accountstree();

        $accountstree->id = isset($row['id']) ? $row['id'] : ''; 
        $accountstree->name = isset($row['name']) ? $row['name'] : ''; 
        $accountstree->customName = isset($row['customName']) ? $row['customName'] : ''; 
        $accountstree->parent = isset($row['parent']) ? $row['parent'] : ''; 
        $accountstree->itemtype = isset($row['itemtype']) ? $row['itemtype'] : ''; 
        $accountstree->itemfrom = isset($row['itemfrom']) ? $row['itemfrom'] : ''; 
        $accountstree->notes = isset($row['notes']) ? $row['notes'] : ''; 
        $accountstree->del = isset($row['del']) ? $row['del'] : ''; 
        $accountstree->userid = isset($row['userid']) ? $row['userid'] : ''; 
        $accountstree->mydate = isset($row['mydate']) ? $row['mydate'] : ''; 
        $accountstree->itemtype2 = isset($row['itemtype2']) ? $row['itemtype2'] : ''; 
        $accountstree->theValue = isset($row['theValue']) ? $row['theValue'] : '';
        $accountstree->theOrder = isset($row['theOrder']) ? $row['theOrder'] : '';
        $accountstree->layingOrder = isset($row['layingOrder']) ? $row['layingOrder'] : '';
        $accountstree->reportid = isset($row['reportid']) ? $row['reportid'] : '';

        //
        $accountstree->parentName = $row['parentName'];
        return $accountstree;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return AccountstreeMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>