<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-04-01 11:09
 */
interface WorkstationassetsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Workstationassets 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param workstationasset primary key
 	 */
	public function delete($assetsId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Workstationassets workstationasset
 	 */
	public function insert($workstationasset);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Workstationassets workstationasset
 	 */
	public function update($workstationasset);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByWorkstationid($value);

	public function queryByAssetsId($value);

	public function queryByWorkhours($value);

	public function queryByEfficiency($value);


	public function deleteByWorkstationid($value);

	public function deleteByAssetsId($value);

	public function deleteByWorkhours($value);

	public function deleteByEfficiency($value);


}
?>