<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-07-01 15:25
 */
interface TemsellbillDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Temsellbill 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param temsellbill primary key
 	 */
	public function delete($sellbillid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Temsellbill temsellbill
 	 */
	public function insert($temsellbill);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Temsellbill temsellbill
 	 */
	public function update($temsellbill);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySellbilldate($value);

	public function queryBySellbillserial($value);

	public function queryBySellbillclientid($value);

	public function queryBySellbilltotaldeptbefor($value);

	public function queryBySellbilltotaldeptafter($value);

	public function queryBySellbilldiscount($value);

	public function queryBySellbilldiscounttype($value);

	public function queryBySellbilltotalbill($value);

	public function queryBySellbillaftertotalbill($value);

	public function queryBySellbilltotalpayed($value);

	public function queryBySellbillfinalbill($value);

	public function queryBySellbillstoreid($value);

	public function queryBySellbillsysdate($value);

	public function queryByUserid($value);

	public function queryByConditions($value);

	public function queryBySellbillclientname($value);

	public function queryBySellbillsaveid($value);

	public function queryBySellbildirectpayment($value);

	public function queryByBillnameid($value);

	public function queryBySellerid($value);

	public function queryByTempclientName($value);

	public function queryBySellQuantity($value);

	public function queryByDeletedsellid($value);

	public function queryByControlname($value);

	public function queryByTax($value);


	public function deleteBySellbilldate($value);

	public function deleteBySellbillserial($value);

	public function deleteBySellbillclientid($value);

	public function deleteBySellbilltotaldeptbefor($value);

	public function deleteBySellbilltotaldeptafter($value);

	public function deleteBySellbilldiscount($value);

	public function deleteBySellbilldiscounttype($value);

	public function deleteBySellbilltotalbill($value);

	public function deleteBySellbillaftertotalbill($value);

	public function deleteBySellbilltotalpayed($value);

	public function deleteBySellbillfinalbill($value);

	public function deleteBySellbillstoreid($value);

	public function deleteBySellbillsysdate($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);

	public function deleteBySellbillclientname($value);

	public function deleteBySellbillsaveid($value);

	public function deleteBySellbildirectpayment($value);

	public function deleteByBillnameid($value);

	public function deleteBySellerid($value);

	public function deleteByTempclientName($value);

	public function deleteBySellQuantity($value);

	public function deleteByDeletedsellid($value);

	public function deleteByControlname($value);

	public function deleteByTax($value);


}
?>