<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-07-01 15:25
 */
interface TemsellandruternbilldetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Temsellandruternbilldetail 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param temsellandruternbilldetail primary key
 	 */
	public function delete($sellbilldetailid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Temsellandruternbilldetail temsellandruternbilldetail
 	 */
	public function insert($temsellandruternbilldetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Temsellandruternbilldetail temsellandruternbilldetail
 	 */
	public function update($temsellandruternbilldetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBuyprice($value);

	public function queryByParcode($value);

	public function queryBySellbillid($value);

	public function queryBySellbilldetailcatid($value);

	public function queryBySellbilldetailproductid($value);

	public function queryBySellbilldetailquantity($value);

	public function queryBySellbilldetailprice($value);

	public function queryBySellbilldetailtotalprice($value);

	public function queryByDiscountvalue($value);

	public function queryByNote($value);

	public function queryByPricetype($value);

	public function queryBySellbilldetaildate($value);

	public function queryBySelltype($value);

	public function queryByProductunitid($value);

	public function queryByBuydiscount($value);

	public function queryByBuydiscounttype($value);

	public function queryByStoreid($value);


	public function deleteByBuyprice($value);

	public function deleteByParcode($value);

	public function deleteBySellbillid($value);

	public function deleteBySellbilldetailcatid($value);

	public function deleteBySellbilldetailproductid($value);

	public function deleteBySellbilldetailquantity($value);

	public function deleteBySellbilldetailprice($value);

	public function deleteBySellbilldetailtotalprice($value);

	public function deleteByDiscountvalue($value);

	public function deleteByNote($value);

	public function deleteByPricetype($value);

	public function deleteBySellbilldetaildate($value);

	public function deleteBySelltype($value);

	public function deleteByProductunitid($value);

	public function deleteByBuydiscount($value);

	public function deleteByBuydiscounttype($value);

	public function deleteByStoreid($value);


}
?>