<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-07-01 15:25
 */
interface TemreturnsellbilldetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Temreturnsellbilldetail 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param temreturnsellbilldetail primary key
 	 */
	public function delete($returnsellbilldetailid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Temreturnsellbilldetail temreturnsellbilldetail
 	 */
	public function insert($temreturnsellbilldetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Temreturnsellbilldetail temreturnsellbilldetail
 	 */
	public function update($temreturnsellbilldetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBuyprice($value);

	public function queryByParcode($value);

	public function queryByReturnsellbillid($value);

	public function queryByReturnsellbilldetailcatid($value);

	public function queryByReturnsellbilldetailproductid($value);

	public function queryByReturnsellbilldetailquantity($value);

	public function queryByReturnsellbilldetailprice($value);

	public function queryByReturnsellbilldetailtotalprice($value);

	public function queryByConditions($value);

	public function queryByNote($value);

	public function queryByPricetype($value);

	public function queryByDiscountvalue($value);

	public function queryByProductunitid($value);

	public function queryByBuydiscount($value);

	public function queryByBuydiscounttype($value);

	public function queryByStoreid($value);


	public function deleteByBuyprice($value);

	public function deleteByParcode($value);

	public function deleteByReturnsellbillid($value);

	public function deleteByReturnsellbilldetailcatid($value);

	public function deleteByReturnsellbilldetailproductid($value);

	public function deleteByReturnsellbilldetailquantity($value);

	public function deleteByReturnsellbilldetailprice($value);

	public function deleteByReturnsellbilldetailtotalprice($value);

	public function deleteByConditions($value);

	public function deleteByNote($value);

	public function deleteByPricetype($value);

	public function deleteByDiscountvalue($value);

	public function deleteByProductunitid($value);

	public function deleteByBuydiscount($value);

	public function deleteByBuydiscounttype($value);

	public function deleteByStoreid($value);


}
?>