<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface StoremovementDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Storemovement 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param storemovement primary key
 	 */
	public function delete($transferproductid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Storemovement storemovement
 	 */
	public function insert($storemovement);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Storemovement storemovement
 	 */
	public function update($storemovement);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByStoreidfrom($value);

	public function queryByStoreidto($value);

	public function queryByProductid($value);

	public function queryByTransferproductamount($value);

	public function queryByTransferproductdate($value);

	public function queryByUserid($value);

	public function queryByConditions($value);


	public function deleteByStoreidfrom($value);

	public function deleteByStoreidto($value);

	public function deleteByProductid($value);

	public function deleteByTransferproductamount($value);

	public function deleteByTransferproductdate($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);


}
?>