<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-04-05 21:26
 */
interface RestaurantplaystationDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Restaurantplaystation 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param restaurantplaystation primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Restaurantplaystation restaurantplaystation
 	 */
	public function insert($restaurantplaystation);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Restaurantplaystation restaurantplaystation
 	 */
	public function update($restaurantplaystation);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByHourPrice($value);

	public function queryByBeingUsed($value);

	public function queryByTableId($value);

	public function queryByServiceId($value);

	public function queryByUserId($value);

	public function queryBySysdate($value);


	public function deleteByName($value);

	public function deleteByHourPrice($value);

	public function deleteByBeingUsed($value);

	public function deleteByTableId($value);

	public function deleteByServiceId($value);

	public function deleteByUserId($value);

	public function deleteBySysdate($value);


}
?>