<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
interface PurchasebillreturnsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Purchasebillreturns 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param purchasebillreturn primary key
 	 */
	public function delete($purchasebillreturnid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Purchasebillreturns purchasebillreturn
 	 */
	public function insert($purchasebillreturn);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Purchasebillreturns purchasebillreturn
 	 */
	public function update($purchasebillreturn);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByRawmaterialssupplierid($value);

	public function queryByPurchasebillreturnsdate($value);

	public function queryByRawmaterialssupplierdebtbefore($value);

	public function queryByRawmaterialssupplierdebtafter($value);

	public function queryByStorerawmaterialid($value);

	public function queryByPurchasebillreturnstotalbeforediscount($value);

	public function queryByPurchasebillreturnsdiscount($value);

	public function queryByPurchasebillreturnspayed($value);

	public function queryByPurchasebillreturnstotalafterdiscount($value);

	public function queryByTempdelete($value);


	public function deleteByRawmaterialssupplierid($value);

	public function deleteByPurchasebillreturnsdate($value);

	public function deleteByRawmaterialssupplierdebtbefore($value);

	public function deleteByRawmaterialssupplierdebtafter($value);

	public function deleteByStorerawmaterialid($value);

	public function deleteByPurchasebillreturnstotalbeforediscount($value);

	public function deleteByPurchasebillreturnsdiscount($value);

	public function deleteByPurchasebillreturnspayed($value);

	public function deleteByPurchasebillreturnstotalafterdiscount($value);

	public function deleteByTempdelete($value);


}
?>