<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface PropertiesDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Properties 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param propertie primary key
 	 */
	public function delete($propertyid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Properties propertie
 	 */
	public function insert($propertie);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Properties propertie
 	 */
	public function update($propertie);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByPropertyname($value);

	public function queryByPropertyparent($value);

	public function queryByPropertydefault($value);

	public function queryByPropertyurl($value);


	public function deleteByPropertyname($value);

	public function deleteByPropertyparent($value);

	public function deleteByPropertydefault($value);

	public function deleteByPropertyurl($value);


}
?>