<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface ProductunitDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productunit 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productunit primary key
 	 */
	public function delete($productunitid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productunit productunit
 	 */
	public function insert($productunit);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productunit productunit
 	 */
	public function update($productunit);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUnitid($value);

	public function queryByProductid($value);

	public function queryByProductnumber($value);

	public function queryByProductunitdate($value);

	public function queryByUserid($value);

	public function queryByCondition($value);


	public function deleteByUnitid($value);

	public function deleteByProductid($value);

	public function deleteByProductnumber($value);

	public function deleteByProductunitdate($value);

	public function deleteByUserid($value);

	public function deleteByCondition($value);


}
?>