<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-09-08 11:42
 */
interface ProductshowsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productshows 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productshow primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productshows productshow
 	 */
	public function insert($productshow);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productshows productshow
 	 */
	public function update($productshow);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductid($value);

	public function queryByQunatity($value);

	public function queryByPrice($value);

	public function queryByTota($value);


	public function deleteByProductid($value);

	public function deleteByQunatity($value);

	public function deleteByPrice($value);

	public function deleteByTota($value);


}
?>