<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface ProductserialDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productserial 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productserial primary key
 	 */
	public function delete($productserailid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productserial productserial
 	 */
	public function insert($productserial,$comment);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productserial productserial
 	 */
	public function update($productserial,$comment);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductid($value);

	public function queryBySerialnumber($value);


	public function deleteByProductid($value);

	public function deleteBySerialnumber($value);


}
?>