<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-10-22 14:58
 */
interface ProductcatunitDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productcatunit 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productcatunit primary key
 	 */
	public function delete($productcatunitid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productcatunit productcatunit
 	 */
	public function insert($productcatunit);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productcatunit productcatunit
 	 */
	public function update($productcatunit);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUnitid($value);

	public function queryByProductcatid($value);

	public function queryByProductnumber($value);

	public function queryByProductcatunitdate($value);

	public function queryByUserid($value);

	public function queryByConditions($value);


	public function deleteByUnitid($value);

	public function deleteByProductcatid($value);

	public function deleteByProductnumber($value);

	public function deleteByProductcatunitdate($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);


}
?>