<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-04-04 21:47
 */
interface PremiumclientDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Premiumclient 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param premiumclient primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Premiumclient premiumclient
 	 */
	public function insert($premiumclient);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Premiumclient premiumclient
 	 */
	public function update($premiumclient);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientId($value);

	public function queryByUserid($value);


	public function deleteByClientId($value);

	public function deleteByUserid($value);


}
?>