<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-06-24 11:58
 */
interface PlaystationclientcardpayhistoryDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Playstationclientcardpayhistory 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param playstationclientcardpayhistory primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Playstationclientcardpayhistory playstationclientcardpayhistory
 	 */
	public function insert($playstationclientcardpayhistory);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Playstationclientcardpayhistory playstationclientcardpayhistory
 	 */
	public function update($playstationclientcardpayhistory);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientid($value);

	public function queryByCardid($value);

	public function queryByCardValBefore($value);

	public function queryByPayAmount($value);

	public function queryByChangeType($value);

	public function queryByCardValAfter($value);

	public function queryByProcessname($value);

	public function queryByModelid($value);

	public function queryByTablename($value);

	public function queryByComment($value);

	public function queryByConditions($value);

	public function queryByUserid($value);

	public function queryBySysDate($value);


	public function deleteByClientid($value);

	public function deleteByCardid($value);

	public function deleteByCardValBefore($value);

	public function deleteByPayAmount($value);

	public function deleteByChangeType($value);

	public function deleteByCardValAfter($value);

	public function deleteByProcessname($value);

	public function deleteByModelid($value);

	public function deleteByTablename($value);

	public function deleteByComment($value);

	public function deleteByConditions($value);

	public function deleteByUserid($value);

	public function deleteBySysDate($value);


}
?>