<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-11-13 10:55
 */
interface OnlinetempstoredetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Onlinetempstoredetail 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param onlinetempstoredetail primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Onlinetempstoredetail onlinetempstoredetail
 	 */
	public function insert($onlinetempstoredetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Onlinetempstoredetail onlinetempstoredetail
 	 */
	public function update($onlinetempstoredetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByStoreid($value);

	public function queryByProductid($value);

	public function queryBySizeid($value);

	public function queryByColorid($value);

	public function queryByQuantity($value);

	public function queryByEdited($value);

	public function queryBySysdate($value);

	public function queryByUserid($value);


	public function deleteByStoreid($value);

	public function deleteByProductid($value);

	public function deleteBySizeid($value);

	public function deleteByColorid($value);

	public function deleteByQuantity($value);

	public function deleteByEdited($value);

	public function deleteBySysdate($value);

	public function deleteByUserid($value);


}
?>