<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-11-13 10:55
 */
interface OnlinetemporderDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Onlinetemporder 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param onlinetemporder primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Onlinetemporder onlinetemporder
 	 */
	public function insert($onlinetemporder);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Onlinetemporder onlinetemporder
 	 */
	public function update($onlinetemporder);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOnlineorderid($value);

	public function queryByCustomerid($value);

	public function queryByOrdertotal($value);

	public function queryByShippingcost($value);

	public function queryByFulltotal($value);

	public function queryByPaytype($value);

	public function queryByCreatedatetime($value);

	public function queryByOrderstatus($value);

	public function queryByTaxValue($value);

	public function queryByUserid($value);


	public function deleteByOnlineorderid($value);

	public function deleteByCustomerid($value);

	public function deleteByOrdertotal($value);

	public function deleteByShippingcost($value);

	public function deleteByFulltotal($value);

	public function deleteByPaytype($value);

	public function deleteByCreatedatetime($value);

	public function deleteByOrderstatus($value);

	public function deleteByTaxValue($value);

	public function deleteByUserid($value);


}
?>