<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-14 14:25
 */
interface OfferpriceconditionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Offerpricecondition 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param offerpricecondition primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Offerpricecondition offerpricecondition
 	 */
	public function insert($offerpricecondition);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Offerpricecondition offerpricecondition
 	 */
	public function update($offerpricecondition);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByDetail($value);


	public function deleteByDetail($value);


}
?>