<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
interface MInitialmaintenanceDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return MInitialmaintenance 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param mInitialmaintenance primary key
 	 */
	public function delete($initialMaintenanceId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param MInitialmaintenance mInitialmaintenance
 	 */
	public function insert($mInitialmaintenance);
	
	/**
 	 * Update record in table
 	 *
 	 * @param MInitialmaintenance mInitialmaintenance
 	 */
	public function update($mInitialmaintenance);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOurSerial($value);

	public function queryByInitialMaintenanceDate($value);

	public function queryByComment($value);

	public function queryByUserId($value);

	public function queryByBranchId($value);

	public function queryByTotalClientCost($value);

	public function queryByDel($value);


	public function deleteByOurSerial($value);

	public function deleteByInitialMaintenanceDate($value);

	public function deleteByComment($value);

	public function deleteByUserId($value);

	public function deleteByBranchId($value);

	public function deleteByTotalClientCost($value);

	public function deleteByDel($value);


}
?>