<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
interface MHandedreportDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return MHandedreport 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param mHandedreport primary key
 	 */
	public function delete($handedReportId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param MHandedreport mHandedreport
 	 */
	public function insert($mHandedreport);
	
	/**
 	 * Update record in table
 	 *
 	 * @param MHandedreport mHandedreport
 	 */
	public function update($mHandedreport);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByStageId($value);

	public function queryByOurSerial($value);

	public function queryByActualCost($value);

	public function queryByInitiateCost($value);

	public function queryByClientCost($value);

	public function queryByComment($value);

	public function queryByUserId($value);

	public function queryByHandedReportDate($value);

	public function queryByArchive($value);

	public function queryByBranchId($value);

	public function queryByDel($value);


	public function deleteByStageId($value);

	public function deleteByOurSerial($value);

	public function deleteByActualCost($value);

	public function deleteByInitiateCost($value);

	public function deleteByClientCost($value);

	public function deleteByComment($value);

	public function deleteByUserId($value);

	public function deleteByHandedReportDate($value);

	public function deleteByArchive($value);

	public function deleteByBranchId($value);

	public function deleteByDel($value);


}
?>