<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
interface MExternalmaintenanceDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return MExternalmaintenance 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param mExternalmaintenance primary key
 	 */
	public function delete($externalmaintenanceId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param MExternalmaintenance mExternalmaintenance
 	 */
	public function insert($mExternalmaintenance);
	
	/**
 	 * Update record in table
 	 *
 	 * @param MExternalmaintenance mExternalmaintenance
 	 */
	public function update($mExternalmaintenance);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOurSerial($value);

	public function queryBySupplierId($value);

	public function queryByExternalmaintenanceDate($value);

	public function queryByComment($value);

	public function queryByExternalmaintenanceReturn($value);

	public function queryByReturnComment($value);

	public function queryBySupplierCost($value);

	public function queryByReturnedDate($value);

	public function queryByBranchId($value);

	public function queryByUserId($value);

	public function queryByDel($value);


	public function deleteByOurSerial($value);

	public function deleteBySupplierId($value);

	public function deleteByExternalmaintenanceDate($value);

	public function deleteByComment($value);

	public function deleteByExternalmaintenanceReturn($value);

	public function deleteByReturnComment($value);

	public function deleteBySupplierCost($value);

	public function deleteByReturnedDate($value);

	public function deleteByBranchId($value);

	public function deleteByUserId($value);

	public function deleteByDel($value);


}
?>