<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-12-29 21:45
 */
interface GoverareaDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Goverarea 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param goverarea primary key
 	 */
	public function delete($goverareaid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Goverarea goverarea
 	 */
	public function insert($goverarea);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Goverarea goverarea
 	 */
	public function update($goverarea);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByGovernmentid($value);

	public function queryByClientareaid($value);


	public function deleteByGovernmentid($value);

	public function deleteByClientareaid($value);


}
?>