<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-11-20 02:16
 */
interface EmployeeclosedayhistoryDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Employeeclosedayhistory 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param employeeclosedayhistory primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Employeeclosedayhistory employeeclosedayhistory
 	 */
	public function insert($employeeclosedayhistory);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Employeeclosedayhistory employeeclosedayhistory
 	 */
	public function update($employeeclosedayhistory);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByEmployeeid($value);

	public function queryByDay($value);

	public function queryByAttendanceTime($value);

	public function queryByDepartureTime($value);

	public function queryByLatePeriod($value);

	public function queryByLateHasPermission($value);

	public function queryByLateDiscount($value);

	public function queryByIsAbsent($value);

	public function queryByAbsentHasPermission($value);

	public function queryByAbsentDiscount($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);

	public function queryByDel($value);


	public function deleteByEmployeeid($value);

	public function deleteByDay($value);

	public function deleteByAttendanceTime($value);

	public function deleteByDepartureTime($value);

	public function deleteByLatePeriod($value);

	public function deleteByLateHasPermission($value);

	public function deleteByLateDiscount($value);

	public function deleteByIsAbsent($value);

	public function deleteByAbsentHasPermission($value);

	public function deleteByAbsentDiscount($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);

	public function deleteByDel($value);


}
?>