<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-11-11 23:00
 */
interface EmployeeattendancesystemDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Employeeattendancesystem 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param employeeattendancesystem primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Employeeattendancesystem employeeattendancesystem
 	 */
	public function insert($employeeattendancesystem);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Employeeattendancesystem employeeattendancesystem
 	 */
	public function update($employeeattendancesystem);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByAttendanceTime($value);

	public function queryByDepartureTime($value);

	public function queryByHalfHourLateWithPermissionDisount($value);

	public function queryByHourLateWithPermissionDisount($value);

	public function queryByHourAndHalfLateWithPermissionDisount($value);

	public function queryByTwoHoursLateWithPermissionDisount($value);

	public function queryByHalfHourLateWithoutPermissionDisount($value);

	public function queryByHourLateWithoutPermissionDisount($value);

	public function queryByHourAndHalfLateWithoutPermissionDisount($value);

	public function queryByTwoHoursLateWithoutPermissionDisount($value);

	public function queryByHalfHourPermissionDisount($value);

	public function queryByHourPermissionDisount($value);

	public function queryByHourAndHalfPermissionDisount($value);

	public function queryByTwoHoursPermissionDisount($value);

	public function queryByDayAbsenceWithPermissionDisount($value);

	public function queryByDayAbsenceWithoutPermissionDisount($value);

	public function queryByUserid($value);

	public function queryByDel($value);

	public function queryBySysdate($value);


	public function deleteByName($value);

	public function deleteByAttendanceTime($value);

	public function deleteByDepartureTime($value);

	public function deleteByHalfHourLateWithPermissionDisount($value);

	public function deleteByHourLateWithPermissionDisount($value);

	public function deleteByHourAndHalfLateWithPermissionDisount($value);

	public function deleteByTwoHoursLateWithPermissionDisount($value);

	public function deleteByHalfHourLateWithoutPermissionDisount($value);

	public function deleteByHourLateWithoutPermissionDisount($value);

	public function deleteByHourAndHalfLateWithoutPermissionDisount($value);

	public function deleteByTwoHoursLateWithoutPermissionDisount($value);

	public function deleteByHalfHourPermissionDisount($value);

	public function deleteByHourPermissionDisount($value);

	public function deleteByHourAndHalfPermissionDisount($value);

	public function deleteByTwoHoursPermissionDisount($value);

	public function deleteByDayAbsenceWithPermissionDisount($value);

	public function deleteByDayAbsenceWithoutPermissionDisount($value);

	public function deleteByUserid($value);

	public function deleteByDel($value);

	public function deleteBySysdate($value);


}
?>