<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-10-10 09:45
 */
interface EmployeeattendanceDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Employeeattendance 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param employeeattendance primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Employeeattendance employeeattendance
 	 */
	public function insert($employeeattendance);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Employeeattendance employeeattendance
 	 */
	public function update($employeeattendance);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByEmpid($value);

	public function queryByTheImage($value);

	public function queryBySysdate($value);

	public function queryByUserid($value);


	public function deleteByEmpid($value);

	public function deleteByTheImage($value);

	public function deleteBySysdate($value);

	public function deleteByUserid($value);


}
?>