<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-04-19 11:00
 */
interface DatedcheckedDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Datedchecked 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param datedchecked primary key
 	 */
	public function delete($datedCheckedID);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Datedchecked datedchecked
 	 */
	public function insert($datedchecked);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Datedchecked datedchecked
 	 */
	public function update($datedchecked);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBankName($value);

	public function queryByAccountNo($value);

	public function queryByCheckValue($value);

	public function queryByCheckNo($value);

	public function queryByDueDate($value);

	public function queryByAntherDetailes($value);

	public function queryByDone($value);

	public function queryByOperationDate($value);

	public function queryByUserID($value);

	public function queryByClientNum($value);


	public function deleteByBankName($value);

	public function deleteByAccountNo($value);

	public function deleteByCheckValue($value);

	public function deleteByCheckNo($value);

	public function deleteByDueDate($value);

	public function deleteByAntherDetailes($value);

	public function deleteByDone($value);

	public function deleteByOperationDate($value);

	public function deleteByUserID($value);

	public function deleteByClientNum($value);


}
?>