<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-03-13 17:56
 */
interface CostcenterDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Costcenter 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param costcenter primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Costcenter costcenter
 	 */
	public function insert($costcenter);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Costcenter costcenter
 	 */
	public function update($costcenter);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByComment($value);

	public function queryByCondation($value);


	public function deleteByName($value);

	public function deleteByComment($value);

	public function deleteByCondation($value);


}
?>