<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface CheckdepositDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Checkdeposit 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param checkdeposit primary key
 	 */
	public function delete($checkdepositid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Checkdeposit checkdeposit
 	 */
	public function insert($checkdeposit,$note);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Checkdeposit checkdeposit
 	 */
	public function update($checkdeposit,$note);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBankaccountid($value);

	public function queryByClientid($value);

	public function queryByCheckdepositnumber($value);

	public function queryByCheckdeposituser($value);

	public function queryByCheckdepositamount($value);

	public function queryByCheckdepositdate($value);

	public function queryByCheckdepositnote($value);

	public function queryByUserid($value);

	public function queryByCondition($value);

	public function queryByAccountbeforevalue($value);


	public function deleteByBankaccountid($value);

	public function deleteByClientid($value);

	public function deleteByCheckdepositnumber($value);

	public function deleteByCheckdeposituser($value);

	public function deleteByCheckdepositamount($value);

	public function deleteByCheckdepositdate($value);

	public function deleteByCheckdepositnote($value);

	public function deleteByUserid($value);

	public function deleteByCondition($value);

	public function deleteByAccountbeforevalue($value);


}
?>