<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-12-07 10:44
 */
interface CashtransferDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Cashtransfer 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param cashtransfer primary key
 	 */
	public function delete($cashtransferid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Cashtransfer cashtransfer
 	 */
	public function insert($cashtransfer);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Cashtransfer cashtransfer
 	 */
	public function update($cashtransfer);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBankaccountid($value);

	public function queryBySaveid($value);

	public function queryByAccountbeforevalue($value);

	public function queryByCashtransferuser($value);

	public function queryByCashtransferamount($value);

	public function queryByCashtransferdate($value);

	public function queryByCashtransfernote($value);

	public function queryByUserid($value);

	public function queryByConditions($value);

	public function queryByCashtransfernumber($value);

	public function queryByType($value);


	public function deleteByBankaccountid($value);

	public function deleteBySaveid($value);

	public function deleteByAccountbeforevalue($value);

	public function deleteByCashtransferuser($value);

	public function deleteByCashtransferamount($value);

	public function deleteByCashtransferdate($value);

	public function deleteByCashtransfernote($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);

	public function deleteByCashtransfernumber($value);

	public function deleteByType($value);


}
?>