<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-09-29 22:16
 */
interface BuypriceshistorybookDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Buypriceshistorybook 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param buypriceshistorybook primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Buypriceshistorybook buypriceshistorybook
 	 */
	public function insert($buypriceshistorybook);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Buypriceshistorybook buypriceshistorybook
 	 */
	public function update($buypriceshistorybook);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTheDate($value);

	public function queryByStoreId($value);

	public function queryByProductid($value);

	public function queryBySizeid($value);

	public function queryByColorid($value);

	public function queryByBuyprice($value);

	public function queryByBuyQuantity($value);

	public function queryBySellQuantity($value);

	public function queryByDel($value);

	public function queryByUserid($value);

	public function queryBySysDate($value);


	public function deleteByTheDate($value);

	public function deleteByStoreId($value);

	public function deleteByProductid($value);

	public function deleteBySizeid($value);

	public function deleteByColorid($value);

	public function deleteByBuyprice($value);

	public function deleteByBuyQuantity($value);

	public function deleteBySellQuantity($value);

	public function deleteByDel($value);

	public function deleteByUserid($value);

	public function deleteBySysDate($value);


}
?>