<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-07-04 13:42
 */
interface BindDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Bind 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param bind primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Bind bind
 	 */
	public function insert($bind);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Bind bind
 	 */
	public function update($bind);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByEmployeeid($value);

	public function queryByBindtype($value);

	public function queryBySaveid($value);

	public function queryBySavevalue($value);

	public function queryByBankid($value);

	public function queryByBankaccount($value);

	public function queryByCkekno($value);

	public function queryByBenefitname($value);

	public function queryByCkekvalue($value);

	public function queryByDailyentryid($value);

	public function queryByUserid($value);

	public function queryByBinddate($value);

	public function queryByDeleted($value);


	public function deleteByEmployeeid($value);

	public function deleteByBindtype($value);

	public function deleteBySaveid($value);

	public function deleteBySavevalue($value);

	public function deleteByBankid($value);

	public function deleteByBankaccount($value);

	public function deleteByCkekno($value);

	public function deleteByBenefitname($value);

	public function deleteByCkekvalue($value);

	public function deleteByDailyentryid($value);

	public function deleteByUserid($value);

	public function deleteByBinddate($value);

	public function deleteByDeleted($value);


}
?>