<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface BillnameDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Billname 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param billname primary key
 	 */
	public function delete($billnameid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Billname billname
 	 */
	public function insert($billname);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Billname billname
 	 */
	public function update($billname);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByUserid($value);

	public function queryByCondition($value);

	public function queryByBillnamedate($value);


	public function deleteByName($value);

	public function deleteByUserid($value);

	public function deleteByCondition($value);

	public function deleteByBillnamedate($value);


}
?>