<?php

/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-04-23 09:50
 */
interface AccountstreeDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @Return Accountstree
     */
    public function load($id);

    /**
     * Get all records from table
     */
    public function queryAll();

    /**
     * Get all records from table ordered by field
     * @Param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn);

    /**
     * Delete record from table
     * @param accountstree primary key
     */
    public function delete($id);

    /**
     * Insert record to table
     *
     * @param Accountstree accountstree
     */
    public function insert($accountstree);

    /**
     * Update record in table
     *
     * @param Accountstree accountstree
     */
    public function update($accountstree);

    /**
     * Delete all rows
     */
    public function clean();

    public function queryByName($value);

    public function queryByCustomName($value);

    public function queryByParent($value);

    public function queryByItemtype($value);

    public function queryByItemfrom($value);

    public function queryByNotes($value);

    public function queryByDel($value);

    public function queryByUserid($value);

    public function queryByMydate($value);

    public function queryByItemtype2($value);

    public function queryByTheValue($value);

    public function queryByTheOrder($value);

    public function queryByLayingOrder($value);

    public function deleteByName($value);

    public function deleteByParent($value);

    public function deleteByItemtype($value);

    public function deleteByItemfrom($value);

    public function deleteByNotes($value);

    public function deleteByDel($value);

    public function deleteByUserid($value);

    public function deleteByMydate($value);

    public function deleteByItemtype2($value);

    public function deleteByTheValue($value);

    public function deleteByTheOrder($value);

    public function deleteByLayingOrder($value);
}

?>