<?php

///***************************** إعادة الجرد ********************///
//the global file operation
session_start();
ob_start();

//global varable
global $showoutside;

//to check if the page from .htacess
//$showoutside = $_GET['sn'];
// get the config file
include_once("../public/config.php");

//here the db files that include in the file
include("../public/include_dao.php");
//Storedetail
require_once('../models/dao/StoredetailDAO.class.php');
require_once('../models/dto/Storedetail.class.php');
require_once('../models/mysql/StoredetailMySqlDAO.class.php');
require_once('../models/mysql/ext/StoredetailMySqlExtDAO.class.php');
//Productcat
require_once('../models/dao/ProductcatDAO.class.php');
require_once('../models/dto/Productcat.class.php');
require_once('../models/mysql/ProductcatMySqlDAO.class.php');
require_once('../models/mysql/ext/ProductcatMySqlExtDAO.class.php');
//Storereport
require_once('../models/dao/StorereportDAO.class.php');
require_once('../models/dto/Storereport.class.php');
require_once('../models/mysql/StorereportMySqlDAO.class.php');
require_once('../models/mysql/ext/StorereportMySqlExtDAO.class.php');

//get the do the action
$do = $_GET['do'];

//here goes the instances and general variables
//Storedetail
$storeDetail = new Storedetail();
$storeDetailDAO = new StoredetailMySqlDAO();
$storeDetailExt = new StoredetailMySqlExtDAO();
//Productcat
$productCatDAO = new ProductcatMySqlDAO();
$productCatExt = new ProductcatMySqlExtDAO();
//Storereport
$storeReportDAO = new StorereportMySqlDAO();
$storeReportExt = new StorereportMySqlExtDAO();

$ProgramsettingDAO = new ProgramsettingsMySqlDAO();

$Programsettingdata = $ProgramsettingDAO->load(1);
$smarty->assign("Programsettingdata", $Programsettingdata);

//check and use the condition that suite this action
if (empty($do)) {
    $storeId = $_GET['storeid'];
    $productId = $_GET['productid'];
    $catId = $_GET['catid'];

    $queryString = ' WHERE';
    /* if(isset($storeId) && !empty($storeId) && $storeId != '-1')
      {
      //get product in this store
      $productData = getProductInStore($storeId);
      }
      else if(isset($catId) && !empty($catId) && $catId != '-1')
      {
      //get products in this category
      $productData = getProductInCategory($catId);
      }
      else if(isset($productId) && !empty($productId) && $productId != '-1')
      {
      //get product by id
      $productData = getProduct($productId);
      } */

    if (isset($storeId) && !empty($storeId) && $storeId != '-1') {
        //get product in this store
        $queryString .= ' storedetail.storeId = ' . $storeId . ' AND';
    }
    if (isset($catId) && !empty($catId) && $catId != '-1') {
        //get products in this category
        $queryString .= ' productcat.productCatId = ' . $catId . ' AND';
    }
    if (isset($productId) && !empty($productId) && $productId != '-1') {
        //get product by id
        $queryString .= ' storedetail.productid = ' . $productId . ' AND';
    }

    //explode string on space character to remove last AND occurence
    $arr = explode(' ', $queryString);
    //print_r($arr);
    if (isset($arr) && count($arr) > 0) {
        $lastWord = end($arr);
        if ($lastWord == 'AND') {//remove it
            array_pop($arr);
            //form the string again
            $queryString = implode(' ', $arr);
        } else if ($lastWord == 'WHERE') {//remove it
            array_pop($arr);
            $queryString = ' ';
        }
        //print("<br>".$queryString."<br>");
    }

    $productData = getInventoryProducts($queryString);
    echo json_encode($productData);
    //$smarty->assign("productData", $productData);
    //here the smarty templates
    //$smarty->display("restaurantRawDestructionView/products.html");
}

/* ===============================
  function in this CONTROLLER
  ================================ */

function getInventoryProducts($queryString) {
    global $storeDetailExt;
    global $storeReportExt;

    $productData = $storeDetailExt->queryProductsInInventoryExt2NoService($queryString);
    if (count($productData) > 0) {
        foreach ($productData as $pro) {
            ///////////To show product category name (the product whole path)
            $parentId = $pro->productCatId;
            //names of product's parents
            $pathArr = fetch_recursive($parentId, $categories);

            //new product name with all path
            $pro->productName = $pro->productName . '/' . $pathArr;

            ///////////تاريخ آخر عملية إعادة جرد
            $lastDate = $storeReportExt->getLastInventoryDateByProductIdAndStoreId($pro->productid, $_REQUEST['storeid']);
            $pro->lastInventoryDate = $lastDate;

            //////////تلوين المنتجات اللي اتعملها إعادة جرد في خلال 10 أيام سابقة.
            $today = date("Y-m-d");
            $date = date("Y-m-d", strtotime('-10 day' . $today));
            $storeReportData = $storeReportExt->getlatestInventoryProductsWithStoreId($pro->productid, $_REQUEST['storeid'], $date, $today);
            if (count($storeReportData) > 0) {
                $pro->status = 1;
            } else {
                $pro->status = 0;
            }
        }
    }
    return $productData;
}

function getProductInStore($storeId) {
    global $storeDetailExt;
    global $storeReportExt;

    $productData = $storeDetailExt->queryWithStoreIdExt($storeId);
    if (count($productData) > 0) {
        foreach ($productData as $pro) {
            ///////////To show product category name (the product whole path)
            $parentId = $pro->productCatId;
            //names of product's parents
            $pathArr = fetch_recursive($parentId, $categories);

            //new product name with all path
            $pro->productName = $pro->productName . '/' . $pathArr;

            ///////////تاريخ آخر عملية إعادة جرد
            $lastDate = $storeReportExt->getLastInventoryDateByProductId($pro->productid);
            $pro->lastInventoryDate = $lastDate;

            //////////تلوين المنتجات اللي اتعملها إعادة جرد في خلال 10 أيام سابقة.
            $today = date("Y-m-d");
            $date = date("Y-m-d", strtotime('-10 day' . $today));
            $storeReportData = $storeReportExt->getlatestInventoryProducts($pro->productid, $date, $today);
            if (count($storeReportData) > 0) {
                $pro->status = 1;
            } else {
                $pro->status = 0;
            }
        }
    }
    return $productData;
}

function getProductInCategory($catId) {
    global $storeDetailExt;
    global $storeReportExt;

    $productData = $storeDetailExt->queryByProductQtyByCatId($catId);
    if (count($productData) > 0) {
        foreach ($productData as $pro) {
            ///////////تاريخ آخر عملية إعادة جرد
            $lastDate = $storeReportExt->getLastInventoryDateByProductId($pro->productid);
            $pro->lastInventoryDate = $lastDate;

            //////////تلوين المنتجات اللي اتعملها إعادة جرد في خلال 10 أيام سابقة.
            $today = date("Y-m-d");
            $date = date("Y-m-d", strtotime('-10 day' . $today));
            $storeReportData = $storeReportExt->getlatestInventoryProducts($pro->productid, $date, $today);
            if (count($storeReportData) > 0) {
                $pro->status = 1;
            } else {
                $pro->status = 0;
            }
        }
    }
    return $productData;
}

function getProduct($productId) {
    global $storeDetailExt;
    global $storeReportExt;

    $productData = $storeDetailExt->queryWithProductIdExt($productId);
    if (count($productData) > 0) {
        foreach ($productData as $pro) {
            ///////////تاريخ آخر عملية إعادة جرد
            $lastDate = $storeReportExt->getLastInventoryDateByProductId($pro->productid);
            $pro->lastInventoryDate = $lastDate;

            //////////تلوين المنتجات اللي اتعملها إعادة جرد في خلال 10 أيام سابقة.
            $today = date("Y-m-d");
            $date = date("Y-m-d", strtotime('-10 day' . $today));
            $storeReportData = $storeReportExt->getlatestInventoryProducts($pro->productid, $date, $today);
            if (count($storeReportData) > 0) {
                $pro->status = 1;
            } else {
                $pro->status = 0;
            }
        }
    }
    return $productData;
}

function fetch_recursive($parentid, $categories) {
    global $productCatExt;

    $catData = $productCatExt->getCategoryAndParentByCatId($parentid);

    if (count($catData) > 0) {
        $categories .= $catData->productCatName . '/';
        $newParentId = $catData->productCatParent;

        return fetch_recursive($newParentId, $categories);
    }
    $categories = substr($categories, 0, strlen($categories) - 1);
    return $categories;
}

?>